/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.persistence;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.sourceforge.freegantt.data.serializer.FileFormatException;
import jp.sourceforge.freegantt.util.XmlUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class Persistence
extends ConcurrentHashMap<String, Object> {
    private static final long serialVersionUID = 7514665998880664425L;
    public static final String TYPE_ATTR = "type";
    public static final String INT_ATTR = "int";
    public static final String LONG_ATTR = "long";
    public static final String DOUBLE_ATTR = "double";

    public abstract String getFilename();

    public static synchronized Persistence getInstance() {
        return null;
    }

    public void putValue(String key, Object value) {
        this.put(key, value);
    }

    public Object getValue(String key, Object defaultValue) {
        Object value = this.get(key);
        if (value != null) {
            return value;
        }
        System.out.println("Preference not found: " + key);
        this.put(key, defaultValue);
        return defaultValue;
    }

    public Integer getInt(String key, Integer defaultValue) {
        Object value = this.getValue(key, defaultValue);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        System.out.println("Preference class cast failed: " + key + ", " + value);
        return defaultValue;
    }

    public void save() {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(this.getFilename());
                this.save(out);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void save(OutputStream out) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation dom = builder.getDOMImplementation();
            Document doc = dom.createDocument("", "freeganttProject", null);
            Element root = doc.getDocumentElement();
            for (String key : this.keySet()) {
                Object value = this.get(key);
                Element ele = XmlUtil.createTextElement(doc, key, String.valueOf(value));
                if (value instanceof Integer) {
                    ele.setAttribute(TYPE_ATTR, INT_ATTR);
                }
                if (value instanceof Long) {
                    ele.setAttribute(TYPE_ATTR, LONG_ATTR);
                }
                if (value instanceof Double) {
                    ele.setAttribute(TYPE_ATTR, DOUBLE_ATTR);
                }
                root.appendChild(ele);
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     */
    public void load() {
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(this.getFilename());
                this.load(in);
            }
            catch (SAXException e) {
                e.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (FileFormatException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void load(InputStream in) throws SAXException, IOException, FileFormatException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            Element root = doc.getDocumentElement();
            List<Element> children = XmlUtil.getChildElements(root);
            for (Element child : children) {
                String key = child.getTagName();
                String value = child.getTextContent();
                if (INT_ATTR.equals(child.getAttribute(TYPE_ATTR))) {
                    this.put(key, Integer.parseInt(value));
                    continue;
                }
                if (LONG_ATTR.equals(child.getAttribute(TYPE_ATTR))) {
                    this.put(key, Long.parseLong(value));
                    continue;
                }
                if (DOUBLE_ATTR.equals(child.getAttribute(TYPE_ATTR))) {
                    this.put(key, Double.parseDouble(value));
                    continue;
                }
                this.put(key, value);
            }
        }
        catch (ParserConfigurationException factory) {
        }
        catch (NumberFormatException e) {
            throw new FileFormatException(e);
        }
    }
}

