/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Column;
import jp.sourceforge.freegantt.data.Project;

public class UpdateViewTaskTableColumnsEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 2456337537476720660L;
    Project project;
    List<Column> oldColumns = new ArrayList<Column>();
    List<Column> newColumns = new ArrayList<Column>();

    public UpdateViewTaskTableColumnsEdit(Project project, List<Column> oldColumns, List<Column> newColumns) {
        this.project = project;
        for (Column column : oldColumns) {
            this.oldColumns.add(column.clone());
        }
        for (Column column : newColumns) {
            this.newColumns.add(column.clone());
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.project.getController().setViewTaskTableColumns(this.project, this.newColumns, this.oldColumns);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.project.getController().setViewTaskTableColumns(this.project, this.oldColumns, this.newColumns);
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.oldColumns = null;
        this.newColumns = null;
    }
}

