/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import java.util.Calendar;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;

public class RemoveAdditionalHolidayEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = -4680421507513488869L;
    Project project;
    Calendar oldCalendar;
    int row;

    public RemoveAdditionalHolidayEdit(Project project, int row) {
        this.project = project;
        this.row = row;
        this.oldCalendar = (Calendar)project.getAdditionalHolidays().get(row).clone();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.project.getController().addAdditionalHoliday(this.oldCalendar, this.row);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.project.getController().removeAdditionalHoliday(this.row);
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.oldCalendar = null;
    }
}

