<?php
/*
 * framework-spider
 * util/ValidateFunctions.class.php
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.06.23
 * 
 */
/**
 * 妥当性検査用の静的メソッドを保持するライブラリクラス
 * @package util ユーティリティパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class ValidateFunctions {
    function ValidateFunctions() {
    }
	/**
	 * 渡された年、月、日がカレンダーで有効な日付であるか検査します。
	 * 有効であればtrue、無効であればfalseを返します。
	 * @param $year 西暦年
	 * @param $month 月
	 * @param $day 日
	 * @return boolean 有効であればtrue、無効であればfalse
	 */
	function isAvailableDate( $year, $month, $day ) {
		if( strlen( trim( $year ) ) == 0 
				|| strlen( trim( $month ) ) == 0 
				|| strlen( trim( $day ) ) == 0 ) {
			return false;
		} else if ( !preg_match("/^[0-9]+$/", $year )
					|| !preg_match("/^[0-9]+$/", $month ) 
					|| !preg_match("/^[0-9]+$/", $day ) ){
			return false;
		} else if ( ( $year < 1900 || $year > 2037 ) 
					|| ( $month < 1 || $month > 12 ) 
					|| ( $day < 1 || $day > 31 ) ) {
			return false;
		} else if ( $month == 2 && $day == 29 ) {
			// 閏年の確認
			if ( ( $year % 400 ) == 0 ) {
				return true;
			} else if ( ( $year % 100 ) == 0 ) {
				return false;
			} else if ( ( $year % 4 ) == 0 ) {
				return true;
			} else {
				return false;
			}
		} else if ( $month == 2 && $day > 29 ) {
			return false;
		} else if ( ( $month == 4 || $month == 6 || $month == 9 || $month == 11 )
					 && $day == 31 ) {
			return false;
		} else {
			return true;
		}
	}
	/**
	 * 渡された年月日フォーマットがカレンダーで有効な日付であるか検査します。
	 * 有効であればtrue、無効であればfalseを返します。
	 * @param $date_strings 日付フォーマット文字列
	 * @return boolean 有効であればtrue、無効であればfalse
	 */
	function isAvailableDateFormat( $date_string ) {
		$elements	= explode('-',$date_string);
		if( count($elements) == 3 ) {
			$year	= array_shift($elements);
			$month	= array_shift($elements);
			$day	= array_shift($elements);
			return ValidateFunctions::isAvailableDate( $year, $month, $day );
		} else {
			return false;
		}
	}
	/**
	 * 渡された時分秒が有効な時間であるか検査します。
	 * 有効であればtrue、無効であればfalseを返します。
	 * @param $hour 時
	 * @param $min 分
	 * @param $sec 秒
	 * @return boolean 有効であればtrue、無効であればfalse
	 */
	function isAvailableTime( $hour, $min, $sec, $permit_decimal_sec=false ) {
		if( preg_match('/^[0-9]{1,2}$/',$hour) == 0 ) {
			return false;
		} else if( $hour < 0 || $hour > 23 ) {
			return false;
		}
		if( preg_match('/^[0-9]{1,2}$/',$min) == 0 ) {
			return false;
		} else if( $min < 0 || $min > 59 ) {
			return false;
		}
		if( !is_null($sec) && strlen($sec) > 0 ) {
			if( $permit_decimal_sec ) {
				if( preg_match('/^[0-9]{1,2}(|\\.[0-9]+)$/',$sec) == 0 ) {
					return false;
				} else if( $sec < 0 || $sec >= 60 ) {
					return false;
				}
			} else {
				if( preg_match('/^[0-9]{1,2}$/',$sec) == 0 ) {
					return false;
				} else if( $sec < 0 || $sec >= 60 ) {
					return false;
				}
			}
		}
		return true;
	}
	/**
	 * 渡された時分秒フォーマットが有効な時間であるか検査します。
	 * 有効であればtrue、無効であればfalseを返します。
	 * @param $time_string 日付フォーマット文字列
	 * @return boolean 有効であればtrue、無効であればfalse
	 */
	function isAvailableTimeFormat( $time_string ) {
		$elements	= explode(':',$time_string);
		if( count($elements) == 2 || count($elements) == 3 ) {
			$hour	= array_shift($elements);
			$min	= array_shift($elements);
			$sec	= array_shift($elements);
			return ValidateFunctions::isAvailableTime( $hour, $min, $sec );
		} else {
			return false;
		}
	}
	/**
	 * 渡された文字列が日時フォーマットとして有効化検査します
	 * 有効であればtrue、無効であればfalseを返します。
	 * @param $datetime_string 日時フォーマット文字列
	 * @return boolean 有効であればtrue、無効であればfalse
	 */
	function isAvailableDatetimeFormat( $datetime_string ) {
		$elements	= explode(' ',$datetime_string);
		if( count($elements) == 2 ) {
			$date_string	= array_shift($elements);
			$time_string	= array_shift($elements);
			if( ValidateFunctions::isAvailableDateFormat($date_string) ) {
				return ValidateFunctions::isAvailableTimeFormat($time_string);
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	/**
	 * 電話番号の書式チェックを行います
	 */
	function validateTelephoneNumber( &$request, $telephone_area_code, $telephone_city_code, $telephone_code, $item_name ) {
		$telephone_len		= strlen( $telephone_area_code ) 
								+ strlen( $telephone_city_code )  
								+ strlen( $telephone_code );
		if ( $telephone_len == 0 ) {
			$telephone_area_code 	= ""; 
			$telephone_city_code 	= ""; 
			$telephone_code			= "";
			$telephone_number		= "";
		} else if ( $telephone_len > 0 ) {
			if ( strlen( $telephone_area_code) == 0 
					|| strlen( $telephone_city_code) == 0 
					|| strlen( $telephone_code) == 0 ) {
				$request->addError($item_name.'は市外局番・市内局番・局番を全て半角数字で入力してください。');
			} else if( $telephone_len > 14 ) {
				$request->addError($item_name.'の数字は合計14文字以下で入力してください。');
			} else {
				$telephone_number	= $telephone_area_code
										. "-" . $telephone_city_code
										. "-" . $telephone_code;
				
				if( !preg_match('/^[0-9]{1,5}$/',$telephone_area_code) ) {
					$request->addError($item_name.'(市外局番)は半角数字のみで入力してください。');
				}
				if( !preg_match('/^[0-9]{1,5}$/',$telephone_city_code) ) {
					$request->addError($item_name.'(市内局番)は半角数字のみで入力してください。');
				}
				if( !preg_match('/^[0-9]{1,5}$/',$telephone_code) ) {
					$request->addError($item_name.'(局番)は半角数字のみで入力してください。');
				}
				if( !$request->isError() ) {
					$telephone_number = $telephone_area_code . "-" . $telephone_city_code . "-" . $telephone_code;
				}
			}
		}
		return $telephone_number;
	}
	/**
	 * 郵便番号の書式チェックを行います
	 */
	function validateZipCode( &$request, $zip_area_code, $zip_city_code, $item_name ) {
		$zip_len		= strlen( $zip_area_code ) 
								+ strlen( $zip_city_code )  
		;
		if ( $zip_len == 0 ) {
			$zip_area_code 		= ""; 
			$zip_city_code 		= ""; 
			$zip_code			= "";
		} elseif ( $zip_len > 0 ) {
			if ( strlen( $zip_area_code) == 0 
					|| strlen( $zip_city_code) == 0 ) {
				$request->addError($item_name.'は全て半角数字で入力してください。');
			} else {
				$zip_code	= $zip_area_code . "-" . $zip_city_code
				;
				if( !preg_match('/^[0-9]{3}$/',$zip_area_code) ) {
					$request->addError($item_name.'(上3桁)は半角数字のみで入力してください。');
				}
				if( !preg_match('/^[0-9]{4}$/',$zip_city_code) ) {
					$request->addError($item_name.'(下4桁)は半角数字のみで入力してください。');
				}
				if( !$request->isError() ) {
					$zip_code = $zip_area_code . "-" . $zip_city_code;
				}
			}
		}
		return $zip_code;
	}
}
?>