<?php
/*
 * framework-spider
 * util/Date.class.php
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.06.23
 * 
 */
class util_Date {
	/**
	 * 指定年月の日数を取得します
	 * @param $year 年
	 * @param $month 月
	 * @return 月の日数,年月の指定が正しくない場合はfalse
	 */
	function getMonthMaxDay( $year, $month ) {
		if( !is_numeric( $year ) || preg_match('/^[0-9]{1,4}$/',$year) == 0 ) {
			return false;
		} else if( !is_numeric( $month ) || preg_match('/^((|0)[1-9]|1[0-2])$/',$month) == 0 ) {
			return false;
		}
		if ( ( $month == 4 || $month == 6 || $month == 9 || $month == 11 ) ) {
			return 30;
		} else if( 2 != $month ) {
			return 31;
		} else {
			if ( ( $year % 400 ) == 0 ) {
				return 29;
			} else if ( ( $year % 100 ) == 0 ) {
				return 28;
			} else if ( ( $year % 4 ) == 0 ) {
				return 29;
			} else {
				return 28;
			}
		}
	}
	/**
	 * 指定年月の日付ををキー、値を曜日とするハッシュを取得します
	 * @param $year 年
	 * @param $month 月
	 * @param $isHash 日付以下をハッシュにするかのフラグ
	 * @return array 指定年月の日付ををキー、値を曜日とするハッシュ
	 */
	function getMonthCalendarHash( $year, $month, $isHash=false, $is2d=false ) {
		if( $maxDays = util_Date::getMonthMaxDay( $year, $month ) ) {
			$calendarHash	= array();
			for ( $day=1; $day<=$maxDays; $day++ ) {
				$wday	= jddayofweek( cal_to_jd( CAL_GREGORIAN, $month, $day, $year ), 0 );
				$vday	= $day;
				if( $is2d ) {
					$vday	= sprintf('%02d',$day);
				}
				if( $isHash ) {
					$calendarHash[$vday]	= array('wday'=>$wday);
				} else {
					$calendarHash[$vday]	= $wday;
				}
			}
			return $calendarHash;
		} else {
			return false;
		}
	}
	/**
	 * 指定年月の1日から末日とその曜日の配列の生成
	 */
	function getDayArray ( $year, $month ) {
		$maxDays	= util_Date::getMonthMaxDay( $year, $month );
		for ( $i=1; $i<=$maxDays; $i++ ) {
			$week_day = jddayofweek( cal_to_jd( CAL_GREGORIAN, $month, $i, $year ), 0 );
			$day_array[$i]	= $week_day;
		}
		return $day_array;
	}
}
?>