<?php
/*
 * framework-spider
 * util/CharUtility.class.php
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.06.23
 * 
 */
/**
 * 文字列用ユーティリティクラス
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class util_CharUtility {
	function util_CharUtility() {
	}
	/**
	 * 渡された文字列を指定されたキーでMD5暗号化して返します。
	 */
	function md5_encrypt($plain_text, $password, $iv_len = 16) {
	   $plain_text .= "\x13";
	   $n = strlen($plain_text);
	   if ($n % 16) $plain_text .= str_repeat("\0", 16 - ($n % 16));
	   $i = 0;
	   $enc_text = util_CharUtility::get_rnd_iv($iv_len);
	   $iv = substr($password ^ $enc_text, 0, 512);
	   while ($i < $n) {
		   $block = substr($plain_text, $i, 16) ^ pack('H*', md5($iv));
		   $enc_text .= $block;
		   $iv = substr($block . $iv, 0, 512) ^ $password;
		   $i += 16;
	   }
	   return base64_encode($enc_text);
	}
	/**
	 * 渡された文字列を渡されたキーで複合化して返します。
	 */
	function md5_decrypt($enc_text, $password, $iv_len = 16) {
	   $enc_text = base64_decode($enc_text);
	   $n = strlen($enc_text);
	   $i = $iv_len;
	   $plain_text = '';
	   $iv = substr($password ^ substr($enc_text, 0, $iv_len), 0, 512);
	   while ($i < $n) {
		   $block = substr($enc_text, $i, 16);
		   $plain_text .= $block ^ pack('H*', md5($iv));
		   $iv = substr($block . $iv, 0, 512) ^ $password;
		   $i += 16;
	   }
	   return preg_replace('/\\x13\\x00*$/', '', $plain_text);
	}
	/**
	 * 
	 */
	function get_rnd_iv($iv_len) {
	   $iv = '';
	   while ($iv_len-- > 0) {
		   $iv .= chr(mt_rand() & 0xff);
	   }
	   return $iv;
	}
	/**
	 * 指定桁数のランダム文字列を生成して返します。
	 */
	function get_rundom_key( $length=16 ) {
		$char_array	= array(
			'0','1','2','3','4','5','6','7','8','9'
			,'a','b','c','d','e','f','g','h','i','j'
			,'k','l','m','n','o','p','q','r','s','t'
			,'u','v','w','x','y','z'
			,'A','B','C','D','E','F','G','H','I','J'
			,'K','L','M','N','O','P','Q','R','S','T'
			,'U','V','W','X','Y','Z'
			,'-'
		);
		$rand_keys	= array_rand($char_array, $length);
		$ret_str	= '';
		foreach ( $rand_keys as $key ) {
			$ret_str .= $char_array[$key];
		}
		return $ret_str;
	}
	/**
	 * 指定桁数のランダム文字列を生成して返します。
	 * 見た目が紛らわしい0,o,O,lなどの文字列は利用しません。
	 */
	function get_rundom_password( $length=8 ) {
		$char_array	= array(
			'1','2','3','4','5','6','7','8','9'
			,'a','b','c','d','e','f','g','h','i','j'
			,'k','m','n','p','q','r','s','t'
			,'u','v','w','x','y','z'
			,'A','B','C','D','E','F','G','H','J'
			,'K','M','N','P','Q','R','S','T'
			,'U','V','W','X','Y','Z'
			,'-'
		);
		$rand_keys	= array_rand($char_array, $length);
		$ret_str	= '';
		foreach ( $rand_keys as $key ) {
			$ret_str .= $char_array[$key];
		}
		return $ret_str;
	}
	/**
	 * 指定桁数のランダム文字列を生成して返します。
	 * 見た目が紛らわしい0,o,O,lなどの文字列は利用しません。
	 */
	function get_rundom_large_char( $length=8 ) {
		$char_array	= array(
			'1','2','3','4','5','6','7','8','9'
			,'A','B','C','D','E','F','G','H','J'
			,'K','M','N','P','Q','R','S','T'
			,'U','V','W','X','Y','Z'
		);
		$rand_keys	= array_rand($char_array, $length);
		$ret_str	= '';
		foreach ( $rand_keys as $key ) {
			$ret_str .= $char_array[$key];
		}
		return $ret_str;
	}
	/**
	 * 指定長のランダムアルファベットを生成して返します
	 */
	function createRundomAlphabet( $length, $type=0 ) {
		$start	= 65;
		$end	= 90;
		if( 1==$type ) {
			$start	= 97;
			$end	= 122;
		}
		return util_CharUtility::createRundomAscii( $length, $start, $end );
	}
	/**
	 * 指定範囲のASCII文字列からランダム文字列を生成します
	 */
	function createRundomAscii( $length=8, $start=33, $end=126 ) {
		$string	= '';
		for( $i=0; $i<$length; $i++ ) {
			$num	= rand( $start, $end );
			$string	.= pack('C*',$num);
		}
		return $string;
	}
	/**
	 * 文字列を数字部分とアルファベット部分ごとの要素に分けて配列で戻します。
	 */
	function explodeAN( $string, $alphSep=0 ) {
		$elm		= '';
		$elmArray	= array();
		$prevChar	= '';
		for( $pos=0; $pos<strlen($string); $pos++ ) {
			$char		= substr($string,$pos,1);
			if( strlen($prevChar) > 0 ) {
				if( preg_match('/[0-9]/',$prevChar) >0 ) {
					if( preg_match('/[0-9]/',$char) >0 ) {
						$elm	.= $char;
					} else {
						array_push( $elmArray, $elm );
						$elm	= $char;
					}
				} else {
					if( preg_match('/[0-9]/',$char) >0 ) {
						array_push( $elmArray, $elm );
						$elm	= $char;
					} else {
						if( $alphSep == 0 ) {
							$elm	.= $char;
						} else {
							if( strlen($elm) >= $alphSep ) {
								array_push( $elmArray, $elm );
								$elm	= $char;
							} else {
								$elm	.= $char;
							}
						}
					}
				}
			} else {
				$elm	.= $char;
			}
			$prevChar	= $char;
		}
		if( strlen($elm) > 0 ) {
			array_push( $elmArray, $elm );
		}
		// 数字部分はint範囲内に収める為最後に文字の長さをチェック
		$returnArray	= array();
		foreach( $elmArray as $elm ) {
			if( preg_match('/^[0-9]+$/',$elm) > 0 ) {
				// 数字の場合文字数を確認
				if( strlen($elm) > 8 ) {
					// 8文字以上ならあふれる恐れが高いので8文字ずつに分割
					for( $i=0; $i<strlen($elm);$i=$i+8 ) {
						$numStr	= trim(substr($elm,$i,8));
						array_push($returnArray,$numStr);
					}
				} else {
					// 8文字以内ならそのまま利用
					array_push($returnArray,$elm);
				}
			} else {
				array_push($returnArray,$elm);
			}
		}
//		return $elmArray;
		return $returnArray;
	}
	/**
	 * CSVデータラインを配列にして返します
	 */
	function csv2Array( $strings ) {
		$strings		= str_replace("\r\n","\n",$strings);
		$strings		= str_replace("\r","\n",$strings);
		$columns		= explode(',',$strings);
		$regist_columns	= array();
		$column_value	= '';
		// カラム値を""と,の関係維持して正確に分割する
		foreach( $columns as $val ) {
			if( strlen($column_value) > 0 ) {
				$column_value	.= ','.$val;
			} else {
				$column_value	.= $val;
			}
			$quote_count	= substr_count( $column_value, '"' );
			if( $quote_count % 2 != 0 ) {
				// クォータ数が偶数でない場合はカラムデータが完結していないので次の行へ
			} else {
				// 完結している場合はカラムとして処理
				if( preg_match('/^"/',$column_value) > 0 && preg_match( '/"$/', $column_value ) > 0 ) {
					$column_value	= preg_replace('/^"/','',$column_value );
					$column_value	= preg_replace('/"$/','',$column_value );
					$column_value	= preg_replace('/""/','"',$column_value );
				}
				$column_value			= mb_convert_kana($column_value,'KVas');
				array_push( $regist_columns, $column_value );
				$column_value	= '';
			}
		}
		return $regist_columns;
	}
	/**
	 * CSVデータラインを指定定義のハッシュにして返します
	 */
	function csv2Hash( $orderDefinitionHash, $strings ) {
		$dataArray	= util_CharUtility::csv2Array( $strings );
		$returnHash	= array();
		if( isset($orderDefinitionHash[0]) ) {
			// キー0番目が格納されているならキーが順序の処理
			foreach( $orderDefinitionHash as $num => $keyName ) {
				$returnHash[$keyName]	= trim($dataArray[$num]);
			}
		} else {
			// キーが数値でないなら値が順序の処理
			foreach( $orderDefinitionHash as $keyName => $order ) {
				$returnHash[$keyName]	= trim($dataArray[$order-1]);
			}
		}
		return $returnHash;
	}
	/**
	 * 正規表現で利用する為の文字パターン用にエスケープします。
	 */
	function escape_regx_str($str){
		return util_CharUtility::escapeRegxStr($str);
	}
	function escapeRegxStr($str){
		$str = str_replace('\\', '\\\\', $str);
		$str = str_replace('*', '\\*', $str);
		$str = str_replace('+', '\\+', $str);
		$str = str_replace('.', '\\.', $str);
		$str = str_replace('?', '\\?', $str);
		$str = str_replace('(', '\\(', $str);
		$str = str_replace(')', '\\)', $str);
		$str = str_replace('{', '\\{', $str);
		$str = str_replace('}', '\\}', $str);
		$str = str_replace('[', '\\[', $str);
		$str = str_replace(']', '\\]', $str);
		$str = str_replace('^', '\\^', $str);
		$str = str_replace('$', '\\$', $str);
		$str = str_replace('|', '\\|', $str);
		$str = str_replace('/', '\\/', $str);
		$str = str_replace('_', '\\_', $str);
		return $str;
	}
}
?>