<?php
/*
 * framework-spider
 * spider/HttpRequest.class.php
 * 
 * グローバル関数定義ファイル
 * spiderで利用するグローバル関数を定義するファイルです
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.06.23
 * 
 */
/**
 * すべてのモジュールのベースクラスです。
 * モジュールはすべて本クラスのサブクラスになります。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.1.00
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class spider_ModuleBase {
	/** Controllerクラスオブジェクトへの参照	*/
	var $controller_object;
	/** HttpOutputクラスオブジェクトへの参照	*/
	var $http_output_object;
	/** HttpRequestクラスオブジェクトへの参照	*/
	var $http_request_object;
	/** 要求モジュール配列	*/
	var $require_module_array	= array();
	/** 後実行モジュール配列	*/
	var $post_module_array		= array();
	/**
	 * コンストラクタ
	 */
	function spider_ModuleBase() {
	}
	/**
	 * モジュールを実行します。
	 * このメソッドをオーバーライドすることにより、モジュールが実行されます。
	 * @param $request 
	 */
	function execute( & $request ) {
	}
	/**
	 * モジュールの後処理を行います。
	 * このメソッドをオーバーライドすることにより、モジュールの後処理として実行されます。
	 * @param $request 
	 */
	function post_process( & $request ) {
	}
	/**
	 * 本モジュールを実行するのに事前に実行する必要があるモジュール名の配列を取得します。
	 */
	function get_require_module_array() {
		return $this->require_module_array;
	}
	/**
	 * 本モジュールを実行した後に必ず実行する必要があるモジュール名配列を取得します。
	 */
	function get_post_module_array() {
		return $this->post_module_array;
	}
	/**
	 * メールレポートを送信します。
	 * @param $subject
	 * @param $message
	 * @param $maito
	 * @deprecated v1.0.00 - 2009/04/17 正式リリース前の仕様です。HttpRequestクラスオブジェクトのmailToメソッドを利用してください。
	 */
	function report_mailto($subject,$message,$mailto=null) {
		if(is_object($this->http_request_object)){
			return $this->http_request_object->mailTo($subject,$message,$mailto);
		}
		return false;
	}
	/**
	 * システム設定された値でメール送信オブジェクトを作成して取得します。
	 * @deprecated v1.0.00 - 2009/04/17 正式リリース前の仕様です。HttpRequestクラスオブジェクトのmailToメソッドを利用してください。
	 */
	function get_system_mailer() {
		if(is_object($this->http_request_object)){
			return $this->http_request_object->getSystemMailer();
		}
		return false;
	}
	/**
	 * ログを出力します。
	 * @param $message ログメッセージ
	 * @param $log_level 出力するログのレベル
	 * @deprecated v1.0.00 - 2009/04/17 正式リリース前の仕様です。HttpRequestクラスオブジェクトのwriteLogメソッドを利用してください。
	 */
	function write_log( $message, $log_level=SPIDER_LOG_LEVEL_INFO ) {
		if(is_object($this->http_request_object)){
			$this->http_request_object->writeLog($message,$log_level);
		}
	}
	/**
	 * Fatalレベルのログを出力します。
	 * @param $message ログメッセージ
	 * @deprecated v1.0.00 - 2009/04/17 正式リリース前の仕様です。HttpRequestクラスオブジェクトのfatalメソッドを利用してください。
	 */
	function fatal($message){
		if(is_object($this->http_request_object)){
			$this->http_request_object->writeLog($message,SPIDER_LOG_LEVEL_FATAL);
		}
	}
	/**
	 * Errorレベルのログを出力します。
	 * @param $message ログメッセージ
	 * @deprecated v1.0.00 - 2009/04/17 正式リリース前の仕様です。HttpRequestクラスオブジェクトのerrorメソッドを利用してください。
	 */
	function error($message){
		if(is_object($this->http_request_object)){
			$this->http_request_object->writeLog($message,SPIDER_LOG_LEVEL_ERROR);
		}
	}
	/**
	 * Warningレベルのログを出力します。
	 * @param $message ログメッセージ
	 * @deprecated v1.0.00 - 2009/04/17 正式リリース前の仕様です。HttpRequestクラスオブジェクトのwarnメソッドを利用してください。
	 */
	function warn($message){
		if(is_object($this->http_request_object)){
			$this->http_request_object->writeLog($message,SPIDER_LOG_LEVEL_WARNING);
		}
	}
	/**
	 * Infoレベルのログを出力します。
	 * @param $message ログメッセージ
	 * @deprecated v1.0.00 - 2009/04/17 正式リリース前の仕様です。HttpRequestクラスオブジェクトのinfoメソッドを利用してください。
	 */
	function info($message){
		if(is_object($this->http_request_object)){
			$this->http_request_object->writeLog($message,SPIDER_LOG_LEVEL_INFO);
		}
	}
	/**
	 * Debugレベルのログを出力します。
	 * @param $message ログメッセージ
	 * @deprecated v1.0.00 - 2009/04/17 正式リリース前の仕様です。HttpRequestクラスオブジェクトのdebugメソッドを利用してください。
	 */
	function debug($message){
		if(is_object($this->http_request_object)){
			$this->http_request_object->writeLog($message,SPIDER_LOG_LEVEL_DEBUG);
		}
	}
}
?>