<?php
/*
 * spider.inc.php
 * @version 1.1.01
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.08.10
 * 
 * (Definition Vars)---------------------------------------
 * 
 * SPIDER_BASE_PATH
 * DIR_PATH_SPIDER
 * 
 * SPIDER_ORG_URL_DOC      = リバースプロキシ時 オリジナルサーバー ドキュメントルートURL
 * SPIDER_ORG_URL_BASE     = リバースプロキシ時 オリジナルサーバー アプリケーションベースURL
 * SPIDER_ORG_URL_REQUEST  = リバースプロキシ時 オリジナルサーバー リクエストURL
 * SPIDER_ORG_URI_BASE     = リバースプロキシ時 オリジナルサーバー アプリケーションベースURI
 * SPIDER_ORG_URI_REQUEST  = リバースプロキシ時 オリジナルサーバー リクエストURI
 * SPIDER_ORG_PHP_SELF     = リバースプロキシ時 オリジナルサーバー アプリケーション内PHP_SELF
 * 
 * SPIDER_URL_DOC          = ドキュメントルートURL
 * SPIDER_URL_BASE         = アプリケーションベースURL
 * SPIDER_URL_REQUEST      = リクエストURL
 * SPIDER_URI_BASE         = アプリケーションベースURI
 * SPIDER_URI_REQUEST      = リクエストURI
 * SPIDER_URI_APP          = アプリケーション内リクエストURI
 * SPIDER_PHP_SELF         = アプリケーションPHP_SELF
 * SPIDER_IS_SSL           = ブラウザからSSLでアクセスされているかどうかを示すboolean型変数
 * 
 * (Definition Vars @deprecated )--------------------------
 * 
 * APPLICATION_BASE_PATH
 * DIR_PATH_SPIDER_DATA
 * APPLICATION_BASE_URL
 * APPLICATION_NML_URL
 * APPLICATION_SSL_URL
 * APPLICATION_BASE_URI
 * 
 * if you need, change $DIR_PATH_SPIDER_DATA for your Env.
 */
/* Data Directory Absolute Path force */
//$DIR_PATH_SPIDER_DATA			= '';
/* Base URI force definition */
//$SPIDER_DEFINE_BASE_URI		= '';
/* active page file folder   */
define('DIR_NAME_PAGES', 'pages');

/*
 * Common Process. you need not to edit.
 */
$scriptFileName	= str_replace(DIRECTORY_SEPARATOR, '/', $_SERVER['SCRIPT_FILENAME'] );
$spiderIncPath	= str_replace(DIRECTORY_SEPARATOR, '/', __FILE__ );
if ( $scriptFileName == $spiderIncPath ) {
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'You can\'t access this file direct!' );
}
define('SPIDER_BASE_PATH', dirname($spiderIncPath) );
// set auto_detect_line_endings
@ini_set('auto_detect_line_endings','1');

// get access env
$requestOrgUri		= str_replace(DIRECTORY_SEPARATOR, '/', $_SERVER['REQUEST_URI']);
$requestUri			= str_replace(DIRECTORY_SEPARATOR, '/', $_SERVER['REQUEST_URI']);
$spiderOrgAccessUri	= str_replace(SPIDER_BASE_PATH,'',$scriptFileName);
$spiderAccessUri	= str_replace(SPIDER_BASE_PATH,'',$scriptFileName);
$spiderOrgPhpSelf	= $requestOrgUri;
if( strpos($spiderOrgPhpSelf,'?') !== false ) {
	$spiderOrgPhpSelf	= substr($spiderOrgPhpSelf,0,strpos($spiderOrgPhpSelf,'?'));
}
if( preg_match('/\\.php$/',$spiderOrgPhpSelf) == 0 ) {
	if( preg_match('/\\/$/',$spiderOrgPhpSelf) == 0 ) {
		$spiderOrgPhpSelf	.= '/';
	}
	$spiderOrgPhpSelf	.= basename($_SERVER['PHP_SELF']);
}
$spiderPhpSelf	= $requestUri;
if( strpos($spiderPhpSelf,'?') !== false ) {
	$spiderPhpSelf	= substr($spiderPhpSelf,0,strpos($spiderPhpSelf,'?'));
}
if( preg_match('/\\.php$/',$spiderPhpSelf) == 0 ) {
	if( preg_match('/\\/$/',$spiderPhpSelf) == 0 ) {
		$spiderPhpSelf	.= '/';
	}
	$spiderPhpSelf	.= basename($_SERVER['PHP_SELF']);
}

$spiderOrgBaseUri	= substr($spiderOrgPhpSelf, 0, strlen($spiderOrgPhpSelf) - strlen($spiderOrgAccessUri) );
$spiderBaseUri		= substr($spiderPhpSelf, 0, strlen($spiderPhpSelf) - strlen($spiderAccessUri) );
$vDocRoot			= substr(SPIDER_BASE_PATH,0,strlen(SPIDER_BASE_PATH)-strlen($spiderOrgBaseUri));

// override setting values
if( isset($SPIDER_DEFINE_BASE_URI) && strlen($SPIDER_DEFINE_BASE_URI) > 0 ) {
	$spiderOrgBaseUri	= $SPIDER_DEFINE_BASE_URI;
	$spiderBaseUri		= $SPIDER_DEFINE_BASE_URI;
}
// add slashes to folder uri
if( preg_match('/^\\//',$spiderBaseUri) == 0 ) {
	$spiderOrgBaseUri	= '/'.$spiderOrgBaseUri;
	$spiderBaseUri		= '/'.$spiderBaseUri;
}
if( preg_match('/\\/$/',$spiderBaseUri) == 0 ) {
	$spiderOrgBaseUri	.= '/';
	$spiderBaseUri		.= '/';
}
// check absolute url
$urlRoot		= null;
$urlRootOrg		= null;
$sslRoot		= 'https://'.$_SERVER['HTTP_HOST'];
$nomalRoot		= 'http://'.$_SERVER['HTTP_HOST'];
if( isset($_SERVER['HTTPS']) && preg_match('/[oO][nN]/', $_SERVER['HTTPS'] ) > 0 ) {
	$urlRoot	= 'https://'.$_SERVER['HTTP_HOST'];
	$urlRootOrg	= 'https://'.$_SERVER['HTTP_HOST'];
	if( '443' != $_SERVER['SERVER_PORT'] ) {
		$urlRoot	.= ':'.$_SERVER['SERVER_PORT'];
		$urlRootOrg	.= ':'.$_SERVER['SERVER_PORT'];
	}
} else {
	$urlRoot	= 'http://'.$_SERVER['HTTP_HOST'];
	$urlRootOrg	= 'http://'.$_SERVER['HTTP_HOST'];
	if( '80' != $_SERVER['SERVER_PORT'] ) {
		$urlRoot	.= ':'.$_SERVER['SERVER_PORT'];
		$urlRootOrg	.= ':'.$_SERVER['SERVER_PORT'];
	}
}
// search spider folder
$spiderFolderPath	= null;
if( isset($DIR_PATH_SPIDER_DATA) && strlen($DIR_PATH_SPIDER_DATA) > 0 ) {
	$spiderFolderPath	= $DIR_PATH_SPIDER_DATA;
} else {
	$targetDir			= dirname($spiderIncPath);
	$rootPathLength			= 1;
	if(isset($_ENV) && isset($_ENV['OS'])
		&& preg_match('/[wW][iI][nN]/',$_ENV['OS'] ) > 0 ) {
		$rootPathLength	= 3;
	}
	while( strlen($targetDir) > $rootPathLength ) {
		$spiderFolderPath	= $targetDir.'/spider';
		if( is_dir( $spiderFolderPath )
			&& file_exists($spiderFolderPath.'/define.inc.php')
			&& file_exists($spiderFolderPath.'/spider_main.inc.php') ) {
			break;
		} else {
			$spiderFolderPath	= null;
		}
		$targetDir	= dirname($targetDir);
	}
	if( is_null($spiderFolderPath) ) {
		$targetDir				= dirname(__FILE__);
		while( strlen($targetDir) > $rootPathLength ) {
			$spiderFolderPath	= $targetDir.'/DATA';
			if( is_dir($spiderFolderPath)
				&& file_exists($spiderFolderPath.'/define.inc.php')
				&& file_exists($spiderFolderPath.'/spider_main.inc.php') ) {
				break;
			} else {
				$spiderFolderPath	= null;
			}
			$targetDir	= dirname($targetDir);
		}
	}
}
if( is_null($spiderFolderPath) ) {
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'Spider DATA Folder is not found!' );
}
define('DIR_PATH_SPIDER',$spiderFolderPath);
// DIR_PATH_SPIDER_DATA @deprecated 1.1.00 - 2010/06/29
define('DIR_PATH_SPIDER_DATA',DIR_PATH_SPIDER);
// If spider folder is found, require define.inc.php
$spiderDefinePath	= DIR_PATH_SPIDER.'/define.inc.php';
if( defined('DIR_PATH_SPIDER')
	&& is_dir(DIR_PATH_SPIDER) && file_exists($spiderDefinePath) ) { 
	require_once( $spiderDefinePath );
} else {
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'Spider Folder is invalid!' );
}

// reverse proxy check
if( isset($GLOBALS['REV_PROXY_HASH'])
	&& is_array($GLOBALS['REV_PROXY_HASH'])
	&& count($GLOBALS['REV_PROXY_HASH']) > 0 ) {
	foreach( $GLOBALS['REV_PROXY_HASH'] as $revHostName => $revHostInfoHash ) {
		if( $revHostName == $_SERVER['HTTP_X_FORWARDED_HOST']
			|| $revHostName == $_SERVER['HTTP_X_FORWARDED_SERVER'] ) {
			$urlRoot		= $revHostInfoHash['protocol'].'://'.$revHostName.'/';
			$spiderBaseUri	= str_replace('//','/',$revHostInfoHash['uri'].$spiderBaseUri);
			$requestUri		= str_replace('//','/',$revHostInfoHash['uri'].$requestUri);
			break;
		}
	}
} else if( defined('APPLICATION_PROXY_REV_HOST') && strlen(APPLICATION_PROXY_REV_HOST) > 0
	&& ( APPLICATION_PROXY_REV_HOST == $_SERVER['HTTP_X_FORWARDED_HOST']
	|| APPLICATION_PROXY_REV_HOST == $_SERVER['HTTP_X_FORWARDED_SERVER'] ) ) {
	$urlRoot		= APPLICATION_PROXY_REV_BASE_URL;
	$spiderBaseUri	= APPLICATION_PROXY_REV_BASE_URI;
	$sslRoot		= APPLICATION_PROXY_REV_SSL_URL;
	$nomalRoot		= APPLICATION_PROXY_REV_NML_URL;
}
// real server env
if( preg_match('/\\/$/',$urlRootOrg) == 0 ) {
	$urlRootOrg	.= '/';
}
$orgUrlBase	= $urlRootOrg.preg_replace('/^\\//','',$spiderOrgBaseUri);
define('SPIDER_ORG_URL_DOC',$urlRootOrg);
define('SPIDER_ORG_URL_BASE',$urlRootOrg.preg_replace('/^\\//','',$spiderOrgBaseUri));
define('SPIDER_ORG_URL_REQUEST',$urlRootOrg.preg_replace('/^\\//','',$requestOrgUri));
define('SPIDER_ORG_URI_BASE',$spiderOrgBaseUri);
define('SPIDER_ORG_URI_REQUEST',$requestOrgUri);
define('SPIDER_ORG_PHP_SELF',$spiderOrgPhpSelf);

// view server env
if( preg_match('/\\/$/',$urlRoot) == 0 ) {
	$urlRoot	.= '/';
}
define('SPIDER_URL_DOC',$urlRoot);
define('SPIDER_URL_BASE',$urlRoot.preg_replace('/^\\//','',$spiderBaseUri));
define('SPIDER_URL_REQUEST',$urlRoot.preg_replace('/^\\//','',$requestUri));
define('SPIDER_URI_BASE',$spiderBaseUri);
define('SPIDER_URI_REQUEST',$requestUri);
define('SPIDER_URI_APP',$spiderAccessUri);
define('SPIDER_PHP_SELF',$spiderPhpSelf);

$isSSL = false;
$ps = strpos(SPIDER_URL_BASE,'https://');
if( $ps !== false && $ps == 0 ) {
	$isSSL = true;
}
define('SPIDER_IS_SSL',$isSSL);
/*
 * @deprecated 1.1.00 - 2010/06/29
 * APPLICATION_BASE_PATH
 * APPLICATION_BASE_URL
 * APPLICATION_NML_URL
 * APPLICATION_SSL_URL
 * APPLICATION_BASE_URI
 */
define('APPLICATION_BASE_PATH',SPIDER_BASE_PATH);
define('APPLICATION_BASE_URL',SPIDER_URL_BASE);
define('APPLICATION_NML_URL',$nomalRoot);
define('APPLICATION_SSL_URL',$sslRoot);
define('APPLICATION_BASE_URI',SPIDER_URI_BASE );
require_once( DIR_PATH_SPIDER . DIRECTORY_SEPARATOR . 'spider_main.inc.php' );
?>