// ***************************************************************************************
//
//	copyright (c) 2003, Kazuhiko TAMURA All rights reserved. 
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		TestUtility.java
//	DATE:		2003.11.29
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.util;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.DecoratedState;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.NumberState;

/**
 *	UnitTestpUtility֐Q
 */
public class TestUtility {
	/**
	 *	ʂւ̔fG~[gB
	 */
	public static void reflectScreen(Model inModel) {
		inModel.flush();
	}
	
	public static String parseDecoratedState(State inState) {
		String aDecoState = "";
		
		if (inState instanceof DecoratedState) {
			aDecoState = parseDecoratedState(((DecoratedState)inState).getDecorated());
		}
		
		String aName = inState.getClass().getName();
		final int aPos = aName.lastIndexOf(".");
		if (aPos >= 0) {
			aName = aName.substring(aPos+1);
		}
		
		String aNum = "";
		if (inState instanceof NumberState) {
			aNum =String.valueOf(((NumberState)inState).getValue());
		}
		
		return "[" + aName + "(" + aNum + ")]" + aDecoState;	
	}
}
