// ***************************************************************************************
//
//	copyright (c) 2003, Kazuhiko TAMURA All rights reserved. 
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		SpaceRenderTest.java
//	DATE:		2003.12.3
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.awt.Rectangle;
import java.awt.Point;
import java.awt.Image;
import java.awt.Color;
import java.awt.image.BufferedImage;

import junit.framework.TestSuite;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.SpaceState;

import jp.gr.java_conf.ktz.puzzle.fillo.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.fillo.app.model.EditableNumberStateManagerImpl;

public class SpaceRenderTest extends junit.framework.TestCase {
	public static junit.framework.Test suite() {
		TestSuite aSuite = new TestSuite("usecase name : update board");
		
		aSuite.addTest(new TestSuite(SpaceRenderTest.class));
		
		return aSuite;
	}
	
	private Model mModel;
	private FilloRenderStrategy mStrategy;
	
	protected void setUp() throws Exception {
		StateManager.initialize(new EditableNumberStateManagerImpl());
		
		mModel = new BoardModel();
		
		mStrategy = new FilloRenderStrategy(mModel);
	}

	private Rectangle calcRenderedBounds(final int inX, final int inY) {
		return new Rectangle(inX * 25, inY * 25, 25, 25);
	}

	/**
	 *	eXgP[XF󔒏Ԃ̕`
	 */
	public void testSpaceCellRender() {
		mModel.createBoard(10, 7);
		
		// ꂽmF
		assertEquals(10, mModel.getWidth());
		assertEquals(7, mModel.getHeight());
		
		// ׂẴZ͋󔒏ԂłB
		for (int y = 0; y < mModel.getHeight(); ++y) {
			for (int x = 0; x < mModel.getWidth(); ++x) {
				assertEquals(true, mModel.isSpaceAt(x, y));
				assertEquals(false, mModel.isNumberAt(x, y));
			}
		}
		
		// Ֆʂ̏Ԃ̎擾
		assertEquals(SpaceState.class, mModel.getCurStateAt(0, 0).getClass());
		assertEquals(SpaceState.class, mModel.getCurStateAt(1, 1).getClass());
		
		// Renderero^
		MockedDefaultRendererFactory aFactory = new MockedDefaultRendererFactory();
		mStrategy.installRenderer(aFactory);
		
		// Locatoroĩ\bhpackage private)
		RendererLocator aLocator = mStrategy.getLocator();
		assertNotNull(aLocator);
		
		// 󔒏Ԃ`悷Renderer擾
		Renderer aRenderer = aLocator.lookup(mModel.getCurStateAt(0, 0));
		assertNotNull(aRenderer);
		
		Image aImage = new BufferedImage(100, 100, BufferedImage.TYPE_INT_RGB);
		
		// \sʂZbg
		aFactory.setExpected("Rendered [SpaceState()] ranging from (0, 0) to (25, 25)");
		
		// \lƌolǂmFB
		aRenderer.render(new RenderEvent(aLocator, aImage.getGraphics(), Color.black, calcRenderedBounds(0, 0), mModel.getCurStateAt(0, 0)));
		
		// ēx󔒏Ԃ`
		aRenderer = aLocator.lookup(mModel.getCurStateAt(1, 1));
		assertNotNull(aRenderer);
		
		// \sʂZbg
		aFactory.setExpected("Rendered [SpaceState()] ranging from (25, 25) to (50, 50)");
		// \lƌolǂmFB
		aRenderer.render(new RenderEvent(aLocator, aImage.getGraphics(), Color.black, calcRenderedBounds(1, 1), mModel.getCurStateAt(1, 1)));
	}			
}