// ***************************************************************************************
//
//	Copyright (C) 2003, Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		RendererLocator.java
//	DATE:		2003.11.14
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;

import jp.gr.java_conf.ktz.puzzle.fillo.app.view.Renderer;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RendererFactory;

/**
 *	w肳ꂽԂ`悷RendererێAC^[tF[X
 */
public interface RendererLocator {
	/**
	 *	w肳ꂽԂɑΉARendererT
	 *
	 *	@param	inState	TΏۂ̏
	 *
	 *	@return	ΉRenderListenerԂB
	 *
	 *	@throws	IllegalArgumentException inStatenull̏ꍇɑoB
	 *	@throws	NoSuchRendererException inStateɑΉRendererȂꍇ
	 */
	public Renderer lookup(State inState);
	
	/**
	 *	LocatorRendererFactoryRenderero^
	 *
	 *	@param	inFactory	Renderer쐬Factory Method
	 *
	 *	@throws	IllegalArgumentException inFactorynull̏ꍇɑoB
	 */
	public void installRenderer(RendererFactory inFactory);
	
	/**
	 *	ΉԂȂꍇɎgpRendererRendererFactoryēo^B
	 *
	 *	@throws	IllegalArgumentException	inRenderernull̏ꍇɑoB
	 */
	public void installDefaultRenderer(AbstractDefaultRendererFactory inFactory);

	/**
	 *	w肳ꂽԂɑΉw肳ꂽRendererLocatorɓo^B
	 *
	 *	@param	inClass	̃L[ƂȂԂClassIuWFNg
	 *	@param	inRenderer	w肳ꂽԂ`悷Renderer
	 *
	 *	@throws	IllegalArgumentException  nꂽ̂ǂ炩null̏ꍇɑo
	 */
	public void addRenderer(Class inClass, Renderer inRenderer);
	
	/**
	 *	@return ΉԂȂꍇɎgpRendererԂ
	 */
	public Renderer getDefaultRenderer();
}
