// ***************************************************************************************
//
//	Copyright (C) 2003, Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		FilloStateRendererFactory.java
//	DATE:		2003.11.14
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.awt.Rectangle;
import java.awt.Graphics;
import java.awt.Color;

import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RendererFactory;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RendererLocator;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.Renderer;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderEvent;

import jp.gr.java_conf.ktz.puzzle.fillo.constants.AppColors;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.*;
import jp.gr.java_conf.ktz.puzzle.fillo.fsm.*;



/**
 *	Ֆʂ̓Ԃ`悷Renderer쐬Factory Method
 */
public class FilloStateRendererFactory implements RendererFactory {
	/**
	 *	Renderer쐬ARendererLocatorɓo^
	 *
	 *	@partam	inLocator	o^ƂȂRendererLocator
	 *
	 *	@throws	IllegalArgumentException inLocatornull̏ꍇAoB
	 */
	public void install(RendererLocator inLocator) {
		inLocator.addRenderer(ActiveSelectionState.class, new ActiveSelectionRenderer());
		inLocator.addRenderer(SpaceState.class, new SpaceRenderer());
		inLocator.addRenderer(NumberState.class, new NumberRenderer());
	}
	
	private static class ActiveSelectionRenderer implements Renderer {
		public void render(RenderEvent inEvent) {
			RendererLocator aLocator = inEvent.getLocator();
			Graphics aGra = inEvent.getGraphics();
			Color aBackColor = inEvent.getBackColor();
			Rectangle aBounds = new Rectangle(inEvent.getBounds());
			ActiveSelectionState aState = (ActiveSelectionState)inEvent.getState();
			
			// ɏC`悷B
			inEvent.reset(aLocator, aGra, aBackColor, aBounds, aState.getDecorated());
			Renderer aRenderer = aLocator.lookup(aState.getDecorated());
			aRenderer.render(inEvent);
			
			// IԂ`
			aGra.setColor(AppColors.SELECTION_COLOR);
			aGra.fillRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
			
			
			aBounds.grow(-aBounds.width / 10, -aBounds.height / 10);
			aGra.setColor(AppColors.ACTIVE_COLOR);
			aGra.drawRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
		}
	}
	
	private static class SpaceRenderer implements Renderer {
		public void render(RenderEvent inEvent) {
			// empty
		}
	}
	
	private static class NumberRenderer implements Renderer {
		public void render(RenderEvent inEvent) {
			java.awt.Graphics aGra = inEvent.getGraphics();
			java.awt.Rectangle aBounds = new Rectangle(inEvent.getBounds());
			
			// ̐`
			final int aNum = ((NumberState)inEvent.getState()).getValue();
			aGra.setColor(AppColors.NUMBER_COLOR);
			String aStr = String.valueOf(aNum);
			java.awt.geom.Rectangle2D aStrBounds = aGra.getFontMetrics().getStringBounds(aStr, aGra);

			final int aX = (int)(aBounds.x + (aBounds.width-aStrBounds.getWidth())/2);
			final int aY = (int)(aBounds.y - aStrBounds.getY() + (aBounds.width-aStrBounds.getHeight())/2);
			aGra.drawString(aStr, aX, aY);
		}
	}
}
