// ***************************************************************************************
//
//	Copyright (C) 2003, Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		FilloRenderStrategy.java
//	DATE:		2003.11.14
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Point;
import java.awt.Color;
import java.awt.Graphics;

import java.awt.image.BufferedImage;

import java.awt.geom.Area;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;

import jp.gr.java_conf.ktz.puzzle.framework.util.GUIUtility;

import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderStrategy;

import jp.gr.java_conf.ktz.puzzle.fillo.constants.AppColors;

/**
 *	tBI~m̔Ֆʂ̕`sNX
 */
public class FilloRenderStrategy implements RenderStrategy {
	private static final int DEFAULT_PIECE_SIZE = 24;
	
	private int mPieceUnit = DEFAULT_PIECE_SIZE;
	private Image mOffImage;
	private Model mModel;
	private int mWidth;
	private int mHeight;
	
	private RendererLocator mLocator = new FilloRendererLocator();
	private RenderEvent mEvent;
	private Color mBackColor = Color.black;
	
	/**
	 *	RXgN^
	 *
	 *	@param	inModel	`e擾邽߂̓Ԃێf
	 */
	public FilloRenderStrategy(Model inModel) {
		mModel = inModel;
	}

	/**
	 *	Ֆʂ̕`s
	 *
	 *	@return `悵Image
	 */
	public Image render() {
		if (mModel.isModified()) {
			Point[] aPos = mModel.lastModified();
			
			Graphics aGraphics = mOffImage.getGraphics();
			try {
				Renderer aDefault = mLocator.getDefaultRenderer();
				for (int i = 0; i < aPos.length; ++i) {
					State aState = mModel.getCurStateAt(aPos[i].x, aPos[i].y);
					Renderer aListener = mLocator.lookup(aState);
					
					resetRenderEvent(aPos[i], aState, aGraphics);
					
					aDefault.render(mEvent);
					
					if (aDefault != aListener) {
						aListener.render(mEvent);
					}
				}
			}
			finally {
				aGraphics.dispose();
			}
			
			mModel.flush();
		}
		
		return getRenderedImage();
	}
	
	private void resetRenderEvent(Point inPos, State inState, Graphics inGra) {
		inGra.setColor(mBackColor);
		
		if (null == mEvent) {
			Rectangle aBounds = new Rectangle(inPos.x * mPieceUnit, inPos.y * mPieceUnit, mPieceUnit, mPieceUnit);
			mEvent = new RenderEvent(mLocator, inGra, mBackColor, aBounds, inState);
		}
		else {
			Rectangle aBounds = mEvent.getBounds();
			aBounds.setBounds(inPos.x * mPieceUnit, inPos.y * mPieceUnit, mPieceUnit, mPieceUnit);
			mEvent.reset(mLocator, inGra, mBackColor, aBounds, inState);
		}
	}
	/**
	 *	Ֆʂ̕`sRendererRendererFactoryēo^
	 *
	 *	@param	inFactory	Renderer쐬Factory Method
	 *
	 *	@throws	IllegalArgumentException	inFactorynull̏ꍇɑoB
	 */
	public void installRenderer(RendererFactory inFactory) {
		mLocator.installRenderer(inFactory);
	}

	/**
	 *	ΉԂȂꍇɎgpRendererRendererFactoryēo^B
	 *
	 *	@throws	IllegalArgumentException	inRenderernull̏ꍇɑoB
	 */
	public void installDefaultRenderer(AbstractDefaultRendererFactory inFactory) {
		mLocator.installDefaultRenderer(inFactory);
	}

	/**
	 *	@return	`悳ꂽC[WԂ
	 */
	public Image getRenderedImage() {
		if (null == mOffImage) {
			setSize(mModel.getWidth(), mModel.getHeight());
		}
		
		return mOffImage;
	}
	
	/**
	 *	backgroundJ[ύX
	 */
	 public void setBackground(java.awt.Color inColor) {
	 	mBackColor = inColor;
	 }

	/**
	 *	Ֆʂ̃TCYύXB
	 *	̎ł́AɑÕTCYƈقȂꍇAImageč\zB
	 *
	 *	@param	inWidth Ֆʂ̕iBoardWnj
	 *	@param	inHeight Ֆʂ̍iBoardWnj
	 */
	public void setSize(final int inWidth, final int inHeight) {
		if (null != mOffImage) {
			if (mModel.getWidth() == inWidth && mModel.getHeight() == inHeight) return;
		}
		
		final int aImageWidth = inWidth * mPieceUnit;
		final int aImageHeight = inHeight * mPieceUnit;
		
		mOffImage = GUIUtility.createImage(aImageWidth, aImageHeight);
		
		mWidth = inWidth;
		mHeight = inHeight;
	}

	/**
	 *	@return	Board̃TCYԂ(ScreenzWnj
	 */
	public java.awt.Dimension getBoardSize() {
		if (null == mOffImage ||
			mModel.getWidth() != mWidth || mModel.getHeight() != mHeight) 
		{
			mOffImage = null;
			setSize(mModel.getWidth(), mModel.getHeight());
		}
		
		return new java.awt.Dimension(mOffImage.getWidth(null), mOffImage.getHeight(null));
	}

	/**
	 *	Z̃TCYύX
	 *	̎ł́AZ͐`ł
	 *
	 *	@param	inSize Z̃TCYiScreenWnj
	 */
	 public void setPieceSize(java.awt.Dimension inSize) {
		mPieceUnit = inSize.width;
	 }

	/**
	 *	@return	Board̃TCYԂ(ScreenzWnj
	 */
	public java.awt.Dimension getPieceSize() {
		return new java.awt.Dimension(mPieceUnit, mPieceUnit);
	}

	/**
	 *	w肳ꂽBoardWn̈ʒuScreenWnɕϊ
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@return	ϊ̍W
	 */
	 public java.awt.Point calcPortToBoardPos(final int inX, final int inY) {
	 	return new java.awt.Point(
	 				(int)Math.floor((double)inX/mPieceUnit), 
	 				(int)Math.floor((double)inY/mPieceUnit)
	 	);
	 }

	/**
	 *	Clipping̈vZB
	 *
	 *	@param	inPos ύXꂽՖʂ̈ʒuB
	 *	@return	Clipping̈
	 */
	public Rectangle getClipBounds() {
		
		return calcClip().getBounds();
	}
	
	private java.awt.Shape calcClip() {
		Area aArea = new Area();
		Rectangle aBounds = new Rectangle();
		Point[] aPos = mModel.lastModified();
		
		for (int i = 0; i <aPos.length; ++i) {
			aBounds.setBounds(aPos[i].x*mPieceUnit, aPos[i].y*mPieceUnit, mPieceUnit, mPieceUnit);
			aArea.add(new Area(aBounds));
		}
		
		return aArea;
	}
	
	RendererLocator getLocator() {
		return mLocator;
	}
}
