// ***************************************************************************************
//
//	Copyright (C) 2003, Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		FilloDefaultRendererFactory.java
//	DATE:		2003.11.30
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.awt.image.BufferedImage;
import java.awt.geom.Line2D;

import jp.gr.java_conf.ktz.puzzle.framework.util.GUIUtility;

import jp.gr.java_conf.ktz.puzzle.fillo.constants.AppColors;

public class FilloDefaultRendererFactory extends AbstractDefaultRendererFactory {

	/**
	 *	obNOEh`悷Renderer쐬B
	 */
	protected Renderer createDefaultRenderer() {
		return new DefaltRenderer();
	}
	
	private static final class DefaltRenderer implements Renderer {
		private BufferedImage mCachedImage;
		
		
		public void render(RenderEvent inEvent) {
			java.awt.Graphics aGra = inEvent.getGraphics();
			java.awt.Rectangle aBounds = inEvent.getBounds();
		
			if (null == mCachedImage) {
				java.awt.Graphics2D aCachedGra = null;
				try {
					mCachedImage = GUIUtility.createImage(aBounds.width, aBounds.height);
					aCachedGra = mCachedImage.createGraphics();
					
					aCachedGra.setColor(AppColors.SPACE);
					aCachedGra.fillRect(0, 0, aBounds.width, aBounds.height);
					
					final float aWidth
						 = (float)((aBounds.width > aBounds.height ? aBounds.width : aBounds.height) * 0.05);
					
					aCachedGra.setColor(AppColors.WALL_COLOR);
					aCachedGra.setStroke(new java.awt.BasicStroke(aWidth));
					Line2D aLine =new Line2D.Float();
					aLine.setLine(0.0, 0.0, aBounds.width * 0.10, 0.0);
					drawLine(aCachedGra, aLine, 0, 0);
					drawLine(aCachedGra, aLine, (int)(aBounds.width * 0.90), 0);
					drawLine(aCachedGra, aLine, 0, aBounds.height);
					drawLine(aCachedGra, aLine, (int)(aBounds.width * 0.90), aBounds.height);

					aLine.setLine(0.0, 0.0, 0.0, (int)(aBounds.height * 0.10));
					drawLine(aCachedGra, aLine, 0, 0);
					drawLine(aCachedGra, aLine, aBounds.width, 0);
					drawLine(aCachedGra, aLine, 0, (int)(aBounds.height * 0.90));
					drawLine(aCachedGra, aLine, aBounds.width, (int)(aBounds.height * 0.90));
				}
				finally {
					aCachedGra.dispose();
				}
			}
			aGra.translate(aBounds.x, aBounds.y);
			aGra.drawImage(mCachedImage, 0, 0, null);
			aGra.translate(-aBounds.x, -aBounds.y);
		}	
		
		private void drawLine(
				java.awt.Graphics2D inGra, Line2D inLine, 
				final int inOffX, final int inOffY)
		{
			inGra.translate(inOffX, inOffY);
			{
				inGra.draw(inLine);
			}
			inGra.translate(-inOffX, -inOffY);
		}
	}
}