// ***************************************************************************************
//
//	copyright (c) 2003, Kazuhiko TAMURA All rights reserved. 
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BoardRenderTest.java
//	DATE:		2003.11.14
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.awt.Rectangle;
import java.awt.Point;
import java.awt.Image;
import java.awt.Color;
import java.awt.image.BufferedImage;

import junit.framework.TestSuite;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.SpaceState;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.DecoratedState;

import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderEvent;

import jp.gr.java_conf.ktz.puzzle.fillo.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.fillo.app.model.SelectionModel;
import jp.gr.java_conf.ktz.puzzle.fillo.app.model.EditableNumberStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.FilloChangeHandler;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.ChangeHandler;

import jp.gr.java_conf.ktz.puzzle.fillo.fsm.ActiveSelectionState;

import jp.gr.java_conf.ktz.puzzle.fillo.util.TestUtility;

public class BoardRenderTest extends junit.framework.TestCase {
	public static junit.framework.Test suite() {
		TestSuite aSuite = new TestSuite("usecase name : update board");
		
		aSuite.addTest(new TestSuite(BoardRenderTest.class));
		
		return aSuite;
	}
	
	private Model mModel;
	private RendererLocator mLocator;
	private FilloChangeHandler mHandler;
	private MockedDefaultRendererFactory mMock;
	
	private Image mImage = new BufferedImage(100, 100, BufferedImage.TYPE_INT_RGB);
	
	protected void setUp() throws Exception {
		StateManager.initialize(new EditableNumberStateManagerImpl());
		
		mModel = new SelectionModel(new BoardModel());
		mModel.createBoard(9, 13);
		
		// Rendereȑ
		FilloRenderStrategy aStrategy = new FilloRenderStrategy(mModel);
		mMock = new MockedDefaultRendererFactory();
		aStrategy.installRenderer(mMock);
		mLocator = aStrategy.getLocator();
		
		mHandler = new FilloChangeHandler(mModel);
		mHandler.notifySelectionChanged(0, 0, false, false);
		
		TestUtility.reflectScreen(mModel);
	}
	
	private Rectangle calcRenderedBounds(final int inX, final int inY) {
		return new Rectangle(inX * 25, inY * 25, 25, 25);
	}

	private State peelState(State inState) {
		State aState = inState;
		
		if (inState instanceof DecoratedState) {
			aState = ((DecoratedState)aState).getDecorated();
		}
		
		return aState;
	}
	
	public void testUniSelectionRender() {
		State aState = null;
		Renderer aRenderer = null;
		
		aState = mModel.getCurStateAt(0, 0);
		
		// (0, 0)̏ԂɑRendererRendererLocator#lookupŎ擾B
		aRenderer = mLocator.lookup(aState);
		
		// \sʂZbg
		mMock.setExpected("Rendered [ActiveSelectionState()][SpaceState()] ranging from (0, 0) to (25, 25)");

		// \lƌolǂmFB
		aRenderer.render(new RenderEvent(mLocator, mImage.getGraphics(), Color.black, calcRenderedBounds(0, 0), aState));
		
		// ꖇ͂
		aState = peelState(aState);
		aRenderer = mLocator.lookup(aState);

		// \sʂZbg
		mMock.setExpected("Rendered [SpaceState()] ranging from (0, 0) to (25, 25)");

		// \lƌolǂmFB
		aRenderer.render(new RenderEvent(mLocator, mImage.getGraphics(), Color.black, calcRenderedBounds(0, 0), aState));

		// (3, 4)IB
		assertEquals(true, mHandler.notifySelectionChanged(3, 4, false, false));
		
		// ύXӏ擾
		java.util.List aList = java.util.Arrays.asList(mModel.lastModified());
		
		// ύXӏ(0, 0), (3, 4)ł邱ƂmFB
		assertEquals(true, aList.contains(new Point(0, 0)));
		assertEquals(true, aList.contains(new Point(3, 4)));
		
		// (0, 0)̏ԂɑRendererRendererLocator#lookupŎ擾B
		aRenderer = mLocator.lookup(mModel.getCurStateAt(0, 0));
		
		// \sʂZbg
		mMock.setExpected("Rendered [SpaceState()] ranging from (0, 0) to (25, 25)");

		// \lƌolǂmFB
		aRenderer.render(new RenderEvent(mLocator, mImage.getGraphics(), Color.black, calcRenderedBounds(0, 0), mModel.getCurStateAt(0, 0)));

		// (3, 4)̏ԂɑRendererRendererLocator#lookupŎ擾B
		aRenderer = mLocator.lookup(mModel.getCurStateAt(3, 4));
		
		// \sʂZbg
		mMock.setExpected("Rendered [ActiveSelectionState()][SpaceState()] ranging from (75, 100) to (100, 125)");

		// \lƌolǂmFB
		aRenderer.render(new RenderEvent(mLocator, mImage.getGraphics(), Color.black, calcRenderedBounds(3, 4), mModel.getCurStateAt(3, 4)));

		// ꖇ͂
		aState = peelState(mModel.getCurStateAt(3, 4));
		aRenderer = mLocator.lookup(aState);

		// \sʂZbg
		mMock.setExpected("Rendered [SpaceState()] ranging from (75, 100) to (100, 125)");

		// \lƌolǂmFB
		aRenderer.render(new RenderEvent(mLocator, mImage.getGraphics(), Color.black, calcRenderedBounds(3, 4), aState));
	}
	
	public void testNumberInputRender() {
		State aState = null;
		Renderer aRenderer = null;
		
		// IӏɂW͂IB	
		assertEquals(true, mHandler.notifyInputOccured(String.valueOf(8)));
		
		
		// ύXӏ擾
		java.util.List aList = java.util.Arrays.asList(mModel.lastModified());
		
		// PӏύXꂽƂmFB
		assertEquals(1, aList.size());
		
		// ύXӏ(0, 0)ł邱ƂmFB
		assertEquals(true, aList.contains(new Point(0, 0)));
		
		// (0, 0)̏ԂɑRenderer擾B	
		aRenderer = mLocator.lookup(mModel.getCurStateAt(0, 0));

		// \sʂZbg
		mMock.setExpected("Rendered [ActiveSelectionState()][NumberState(8)] ranging from (0, 0) to (25, 25)");

		// \sʂƓmFB
		aRenderer.render(new RenderEvent(mLocator, mImage.getGraphics(), Color.black, calcRenderedBounds(0, 0), mModel.getCurStateAt(0, 0)));

		aState = peelState(mModel.getCurStateAt(0, 0));
		aRenderer = mLocator.lookup(aState);

		// \sʂZbg
		mMock.setExpected("Rendered [NumberState(8)] ranging from (0, 0) to (25, 25)");

		// \sʂƓmFB
		aRenderer.render(new RenderEvent(mLocator, mImage.getGraphics(), Color.black, calcRenderedBounds(0, 0), aState));
	}
	

}
