//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BoardModelTest.java
//	DATE:		2003.12.3
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.model;

import junit.framework.TestSuite;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;


public class BoardModelTest extends junit.framework.TestCase {
	public static junit.framework.Test suite() {
		TestSuite aSuite = new TestSuite("usecase name : ");
		
		aSuite.addTest(new TestSuite(BoardModelTest.class));
		
		return aSuite;
	}
	
	private Model mModel;
	
	protected void setUp() throws Exception {
		StateManager.initialize(new EditableNumberStateManagerImpl());
		
		mModel = new SelectionModel(new BoardModel());
	}

	/**
	 *	eXgP[XFՖʂ̍쐬
	 */
	public void testCreateBoard() {
		mModel.createBoard(3, 6);
	
		// ꂽmF
		assertEquals(3, mModel.getWidth());
		assertEquals(6, mModel.getHeight());
		
		// (0, 0)݂͑͂
		assertEquals(true, mModel.contains(0, 0));
		
		// ՊOfalseԂ͂
		assertEquals(false, mModel.contains(-1, -1));
		assertEquals(false, mModel.contains(3, 6));
	}
}