// ***************************************************************************************
//
//	copyright (c) 2003, Kazuhiko TAMURA All rights reserved. 
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		ProblemLoadTest.java
//	DATE:		2003.11.28
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.controller;

import java.awt.Point;

import junit.framework.TestSuite;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.SpaceState;

import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderEvent;

import jp.gr.java_conf.ktz.puzzle.fillo.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.fillo.app.model.SelectionModel;
import jp.gr.java_conf.ktz.puzzle.fillo.app.model.EditableNumberStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.fillo.util.TestUtility;

public class ProblemLoadTest extends junit.framework.TestCase {
	public static TestSuite suite() {
		TestSuite aSuite = new TestSuite("usecase name : load problem");
		
		aSuite.addTest(new TestSuite(ProblemLoadTest.class));
		
		return aSuite;
	}
	
	private Model mModel;
	private FilloChangeHandler mHandler;
	private FilloProblemLoader mLoader;
	
	protected void setUp() {
		StateManager.initialize(new EditableNumberStateManagerImpl());
		mModel = new SelectionModel(new BoardModel());
		mModel.createBoard(4, 5);
		mHandler = new FilloChangeHandler(mModel);
		mHandler.notifySelectionChanged(3, 1, false, false);
		mLoader = new FilloProblemLoader(mModel);
		
		TestUtility.reflectScreen(mModel);
	}
	
	public void testLoadProblem() {
		assertEquals(true, mHandler.isActivePos(new Point(3, 1)));
		
		mLoader.loadProblem(new ProblemInfo("untitled", 0, 5, 4, "s, 2, s, s, 3, 2, s, s, s, s, s, s, s, s, s, 4, s, s, s, 1".split(",[\\s]*")));
		mHandler.notifySelectionChanged(0, 0, false, false);
		
		// Ֆʂ͕ύXĂB
		assertEquals(true, mModel.isModified());
		
		assertEquals(true, mHandler.isActivePos(new Point(0, 0)));
		
		// Ֆʂ̃TCY5X4ł邱Ƃ`FbN
		assertEquals(5, mModel.getWidth());
		assertEquals(4, mModel.getHeight());
		
		// ׂĕύXĂ
		assertEquals(20, mModel.lastModified().length);
		
		// (0, 0)̏Ԃ[Active Pos -> [Space]]ł邱ƂmFB
		String aExpected = "[ActiveSelectionState()][SpaceState()]";
		assertEquals(aExpected, TestUtility.parseDecoratedState(mModel.getCurStateAt(0, 0)));
		
		// (4, 3)̏Ԃ[Number(1)]ł邱ƂmF
		aExpected = "[NumberState(1)]";
		assertEquals(aExpected, TestUtility.parseDecoratedState(mModel.getCurStateAt(4, 3)));
	}
	
	public void testLoadProblemForSameSize() {
		assertEquals(true, mHandler.isActivePos(new Point(3, 1)));

		mLoader.loadProblem(new ProblemInfo("untitled", 0, 4, 5, "4, s, 2, s, s, s, s, 2, s, s, s, s, s, s, s, s, 1, s, s, 3".split(",")));
		mHandler.notifySelectionChanged(0, 0, false, false);
	
		// Ֆʂ͕ύXĂB
		assertEquals(true, mModel.isModified());
		
		assertEquals(true, mHandler.isActivePos(new Point(0, 0)));

		// TӏύXĂ
		assertEquals(5, mModel.lastModified().length);
		
		// Ֆʂ̃TCYSwTł邱Ƃ`FbN
		assertEquals(4, mModel.getWidth());
		assertEquals(5, mModel.getHeight());
		
		// ύXʒůmF
		java.util.List aList = java.util.Arrays.asList(mModel.lastModified());
		assertEquals(true, aList.contains(new Point(0, 0)));
		assertEquals(true, aList.contains(new Point(2, 0)));
		assertEquals(true, aList.contains(new Point(3, 1)));
		assertEquals(true, aList.contains(new Point(0, 4)));
		assertEquals(true, aList.contains(new Point(3, 4)));
		
		// ύXӏׂ͂Đ
		for (int i = 0; i < aList.size(); ++i) {
			Point aPos = (Point)aList.get(i);
			assertEquals(true, mModel.isNumberAt(aPos.x, aPos.y));
		}
	
		// (0, 0)̏Ԃ[Active Pos -> [Space]]ł邱ƂmFB
		String aExpected = "[ActiveSelectionState()][NumberState(4)]";
		assertEquals(aExpected, TestUtility.parseDecoratedState(mModel.getCurStateAt(0, 0)));
		
		// (3, 4)̏Ԃ[Number(1)]ł邱ƂmF
		aExpected = "[NumberState(3)]";
		assertEquals(aExpected, TestUtility.parseDecoratedState(mModel.getCurStateAt(3, 4)));
		
	}
}