// ***************************************************************************************
//
//	copyright (c) 2003, Kazuhiko TAMURA All rights reserved. 
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		Main.java
//	DATE:		2003.11.29
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app;

import java.awt.Frame;
import java.awt.BorderLayout;

import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;

import jp.gr.java_conf.ktz.puzzle.framework.StateManager;

import jp.gr.java_conf.ktz.puzzle.fillo.app.view.FilloBoardView;

import jp.gr.java_conf.ktz.puzzle.fillo.app.model.EditableNumberStateManagerImpl;

public class Main {
	public static void main(String[] inArgs) {
		StateManager.initialize(new EditableNumberStateManagerImpl());
		
		Frame aFrame = new Frame("Fillo Player");
		aFrame.addWindowListener(new WindowListener() {
			public void windowClosing(WindowEvent inEvent) {
				System.exit(0);
			}
			
			public void windowClosed(WindowEvent inEvent) {}
			public void windowActivated(WindowEvent inEvent) {}
			public void windowDeactivated(WindowEvent inEvent) {}
			public void windowOpened(WindowEvent inEvent) {}
			public void windowIconified(WindowEvent inEvent) {}
			public void windowDeiconified(WindowEvent inEvent) {}
			
		});
		
		FilloBoardView aView = new FilloBoardView();
		aView.initialize();
		
		aFrame.add(aView, BorderLayout.CENTER);
		aFrame.pack();
		aFrame.setVisible(true);
	}
}