// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BoardScroller.java
//	DATE:		2003.5.27
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework.view.awt;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.ScrollPane;

import java.awt.Component;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import java.awt.event.AdjustmentEvent;

import jp.gr.java_conf.ktz.puzzle.framework.util.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.framework.util.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.framework.util.Command;

import jp.gr.java_conf.ktz.puzzle.framework.view.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.PieceSizeCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.KeyScrollCommand;

/**
 *	Ֆʂ̃XN[tbNNX
 */
public class BoardScroller extends BoardContainer {
	/**
	 *	RXgN^
	 *
	 *	@param	inContainer	R|[lg
	 */
	public BoardScroller(java.awt.Container inContainer) {
		super(inContainer);
	}
	
	/**
	 *	View
	 */
	protected void initializeSelf() {
	}
	
	/**
	 *	Board1s[X̃TCYZbg
	 *
	 *	@param	inSize ZTCY
	 */
	private int setPieceSize(final int inSize) {
		// Scroller̃XN[ʂύX
		
		ScrollPane aPane = (ScrollPane)getComponent();
		
		aPane.getHAdjustable().setUnitIncrement(inSize);
		aPane.getVAdjustable().setUnitIncrement(inSize);
		
		return inSize;
	}
	
	/**
	 *	R|[lg̃TCYύX
	 *	ƂēnĺAsubcomponent̃TCYłB
	 *	
	 *	@param	inWidth		subcomponent̕
	 *	@param	inHeight	subcomponent̍
	 *	@return	component̃TCY
	 */
	private void setComponentSize(
			final int inWidth, final int inHeight)
	{
		ScrollPane aPane = (ScrollPane)getComponent();
		final int aHHeight = aPane.getHScrollbarHeight();
		final int aVWidth = aPane.getVScrollbarWidth();
		
		int aWidth = inWidth + aVWidth;
		int aHeight = inHeight + aHHeight;

		aPane.setSize(aWidth, aHeight);
	}
	
	/**
	 *	J[\L[ɂXN[s
	 */
	public void processKeyScroll(Rectangle inActiveBounds) {
		ScrollPane aPane = (ScrollPane)getComponent();
		
		Rectangle aViewBounds = new Rectangle(aPane.getViewportSize());
		
		if (! aViewBounds.contains(inActiveBounds)) {
			Component aSubCompo = aPane.getComponent(0);
			
			int aX = 0;
			int aY = 0;
		
			if (aViewBounds.width + aViewBounds.x < inActiveBounds.width + inActiveBounds.x) {
				aX -= inActiveBounds.width;
			}
			else if (aViewBounds.x > inActiveBounds.x) {
				aX += inActiveBounds.width;
			}
			else if (aViewBounds.height + aViewBounds.y < inActiveBounds.height + inActiveBounds.y) {
				aY -= inActiveBounds.height;
			}
			else if (aViewBounds.y > inActiveBounds.y) {
				aY += inActiveBounds.height;
			}
			
			java.awt.Adjustable aHScroller = aPane.getHAdjustable();
			java.awt.Adjustable aVScroller = aPane.getVAdjustable();
			
			aHScroller.setValue(aHScroller.getValue() - aX);
			aVScroller.setValue(aVScroller.getValue() - aY);
		}
		repaint();
	}
	
	/**
	 *	Command̎
	 *
	 *	@param	inCommand	Command
	 */
	protected void processCommandImpl(Command inCommand) {
		final Class aClass = inCommand.getClass();
		
		if (aClass == PieceSizeCommand.class) {
			final int aSize = ((PieceSizeCommand)inCommand).getPieceSize();
			setPieceSize(aSize);
			inCommand.consume();
		}
		else if (aClass == BoardSizeCommand.class) {
			final int aWidth = ((BoardSizeCommand)inCommand).getComponentWidth();
			final int aHeight = ((BoardSizeCommand)inCommand).getComponentHeight();
			setComponentSize(aWidth, aHeight);
		}
		else if (aClass == KeyScrollCommand.class) {
			processKeyScroll(((KeyScrollCommand)inCommand).getActiveBounds());
			inCommand.consume();
		}
	}
}