// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		Direction.java
//	DATE:		2003.5.12	initial version
//	MODIFIED	2003.12.2	FrameworkɈڍsB
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework.constants;

import java.awt.Point;

/**
 *	Atype safe enumeration
 */
public class Direction {
	/** k */
	public static final Direction NORTH = new Direction("NORTH", new Point(0, -1));
	
	/**  */
	public static final Direction SOUTH = new Direction("SOUTH", new Point(0, 1));
	
	/**  */
	public static final Direction WEST = new Direction("WEST", new Point(-1, 0));
	
	/**  */
	public static final Direction EAST = new Direction("EAST", new Point(1, 0));
	
	/** k */
	public static final Direction NORTH_WEST = new Direction("NORTH_WEST", new Point(-1, -1));
	
	/** 쓌 */
	public static final Direction SOUTH_EAST = new Direction("SOUTH_EAST", new Point(1, 1));
	
	/** 쐼 */
	public static final Direction SOUTH_WEST = new Direction("SOUTH_WEST", new Point(-1, 1));
	
	/** k */
	public static final Direction NORTH_EAST = new Direction("NORTH_EAST", new Point(1, -1));

	/** ǂ̕wĂȂ */
	public static final Direction NO = new Direction("NO", new Point(0, 0));
	
	private Point mDirection;
	private String mName;
	
	/**
	 *	@return	g̔Ֆʏł̕ωʂԂB
	 */
	public Point getDifference() {
		return new Point(mDirection);
	}
	
	/**
	 *	̕\Ԃ
	 *
	 *	@return	̕\
	 */
	public String getName() {
		return mName;
	}
	
	/**
	 *	RXgN^
	 *
	 *	@param	inName	̕\
	 *	@param	inDirection ɑΉړ
	 */
	private Direction(String inName, Point inDirection) {
		mDirection = inDirection;
		mName = inName;
	}
	
	/**
	 *	̃IuWFNg̃fobOԂ
	 *
	 *	@return	fobO
	 */
	public String toString() {
		return Direction.class + "[mName = " + mName + "]";
	}
}