//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//	NAME:		StateManager.java
//	DATE:		2003.5.27
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;

/**
 * ԑJڂǗIuWFNg
 * ̃IuWFNgg͉A<code>initialize(...)</code>
 * \bhŎw肳ꂽɓ]B
 *
 *	@see	State
 *	@see	StateManagerImpl
 */
public class StateManager implements StateManagerImpl {	
	private static StateManagerImpl sImpl;
	
	// initialized-on-demand holder class
	private static class Holder {
		static StateManager sInstance = new StateManager();
	}
	
	/**
	 *	w肳ꂽŏB
	 *
	 *	@param	inImpl ԑJڂ̎
	 */
	public static void initialize(StateManagerImpl inImpl) {
		if (null == inImpl) throw new IllegalArgumentException("cannnot initialze with NULL");
		sImpl = inImpl;
	}
	
	/**
	 *	@return	ԑJڃ}l[WԂ
	 */
	public static StateManager getInstance() {
		if (null == sImpl) {
			throw new IllegalStateException(
					"StateManagerImpl is not initialized.\n"
					+"Need to called StateManager.initialize() "
					+"followed by StateManager.getInstance(),"
			);
		}
		return Holder.sInstance;
	}

	/**
	 *	w肳ꂽIDɑΉԂ쐬B
	 *
	 *	@param	inStateID ԂɑΉID
	 *	@return 쐬ꂽ
	 */
	public State createStateOf(String inStateID) {
		return sImpl.createStateOf(inStateID);
	}
	
	/**
	 *	ftHg̏Ԃ쐬B
	 *
	 *	@param	inStateID ԂɑΉID
	 *	@return 쐬ꂽ
	 */
	public State createDefaultState() {
		return sImpl.createDefaultState();
	}
	
	/**
	 *	w肵ԂɑΉAIDԂB
	 *	́AcreateStateOf̋t̑łB
	 *
	 *	@param	inState ϊ
	 *	@return	ԂɑΉAID
	 */
	public String findIdentityOf(State inState) {
		return sImpl.findIdentityOf(inState);
	}

	/**
	 *	Ԃ1i߂B
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 */
	public State getNextState(State inState) {
		return sImpl.getNextState(inState);
	}
	
	/**
	 *	Ԃ1i߂B
	 *	ŁAinEventlɏ]ēJڂs
	 *
	 *	@param inState ݂̏
	 *	@param inEvent JڂɊւCxgl
	 *	@return ̏
	 */
	public State getNextState(State inState, StateEventCode inEvent) {
		return sImpl.getNextState(inState, inEvent);
	}

	/**
	 *	Ԃ1߂B
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 */
	public State getPrevState(State inState) {
		return sImpl.getPrevState(inState);
	}
	
	/**
	 *	Ԃ1߂B
	 *	ŁAinEventlɏ]ēJڂs
	 *
	 *	@param inState ݂̏
	 *	@param inEvent JڂɊւCxgl
	 *	@return ̏
	 */
	public State getPrevState(State inState, StateEventCode inEvent) {
		return sImpl.getPrevState(inState, inEvent);
	}
	
	/**
	 *	w肳ꂽԂł邩ǂׂ
	 *
	 *	@param	inState 
	 *	@return	łtrueԂB
	 */
	public boolean isNumberState(State inState) {
		return sImpl.isNumberState(inState);
	}
	
	/**
	 *	w肳ꂽԂ󔒂ł邩ǂׂ
	 *
	 *	@param	inState 
	 *	@return	󔒂łtrueԂB
	 */
	public boolean isSpaceState(State inState) {
		return sImpl.isSpaceState(inState);
	}
	
	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *	̎ł́AJڂ܂ł̃`FbN͍sȂB
	 *
	 *	@param inState `FbNState object
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	public boolean isTransit(State inState) {
		return sImpl.isTransit(inState);
	}
	
	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *
	 *	@param inState `FbNState object
	 *	@param inEvent ɓJڂ҂̂łΎw肷B
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	public boolean isTransit(State inState, StateEventCode inEvent) {
		return sImpl.isTransit(inState, inEvent);
	}

	private StateManager() {
	}
}