/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.AbstractDefaultRendererFactory;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.FilloRendererLocator;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderEvent;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderStrategy;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.Renderer;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RendererFactory;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RendererLocator;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.util.GUIUtility;

public class FilloRenderStrategy
implements RenderStrategy {
    private static final int DEFAULT_PIECE_SIZE = 24;
    private int mPieceUnit = 24;
    private Image mOffImage;
    private Model mModel;
    private int mWidth;
    private int mHeight;
    private RendererLocator mLocator = new FilloRendererLocator();
    private RenderEvent mEvent;
    private Color mBackColor = Color.black;

    public FilloRenderStrategy(Model model) {
        this.mModel = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image render() {
        if (this.mModel.isModified()) {
            Point[] pointArray = this.mModel.lastModified();
            Graphics graphics = this.mOffImage.getGraphics();
            try {
                Renderer renderer = this.mLocator.getDefaultRenderer();
                for (int i = 0; i < pointArray.length; ++i) {
                    State state = this.mModel.getCurStateAt(pointArray[i].x, pointArray[i].y);
                    Renderer renderer2 = this.mLocator.lookup(state);
                    this.resetRenderEvent(pointArray[i], state, graphics);
                    renderer.render(this.mEvent);
                    if (renderer == renderer2) continue;
                    renderer2.render(this.mEvent);
                }
            }
            finally {
                graphics.dispose();
            }
            this.mModel.flush();
        }
        return this.getRenderedImage();
    }

    private void resetRenderEvent(Point point, State state, Graphics graphics) {
        graphics.setColor(this.mBackColor);
        if (null == this.mEvent) {
            Rectangle rectangle = new Rectangle(point.x * this.mPieceUnit, point.y * this.mPieceUnit, this.mPieceUnit, this.mPieceUnit);
            this.mEvent = new RenderEvent(this.mLocator, graphics, this.mBackColor, rectangle, state);
        } else {
            Rectangle rectangle = this.mEvent.getBounds();
            rectangle.setBounds(point.x * this.mPieceUnit, point.y * this.mPieceUnit, this.mPieceUnit, this.mPieceUnit);
            this.mEvent.reset(this.mLocator, graphics, this.mBackColor, rectangle, state);
        }
    }

    public void installRenderer(RendererFactory rendererFactory) {
        this.mLocator.installRenderer(rendererFactory);
    }

    public void installDefaultRenderer(AbstractDefaultRendererFactory abstractDefaultRendererFactory) {
        this.mLocator.installDefaultRenderer(abstractDefaultRendererFactory);
    }

    public Image getRenderedImage() {
        if (null == this.mOffImage) {
            this.setSize(this.mModel.getWidth(), this.mModel.getHeight());
        }
        return this.mOffImage;
    }

    public void setBackground(Color color) {
        this.mBackColor = color;
    }

    public void setSize(int n, int n2) {
        if (null != this.mOffImage && this.mModel.getWidth() == n && this.mModel.getHeight() == n2) {
            return;
        }
        int n3 = n * this.mPieceUnit;
        int n4 = n2 * this.mPieceUnit;
        this.mOffImage = GUIUtility.createImage((int)n3, (int)n4);
        this.mWidth = n;
        this.mHeight = n2;
    }

    public Dimension getBoardSize() {
        if (null == this.mOffImage || this.mModel.getWidth() != this.mWidth || this.mModel.getHeight() != this.mHeight) {
            this.mOffImage = null;
            this.setSize(this.mModel.getWidth(), this.mModel.getHeight());
        }
        return new Dimension(this.mOffImage.getWidth(null), this.mOffImage.getHeight(null));
    }

    public void setPieceSize(Dimension dimension) {
        this.mPieceUnit = dimension.width;
    }

    public Dimension getPieceSize() {
        return new Dimension(this.mPieceUnit, this.mPieceUnit);
    }

    public Point calcPortToBoardPos(int n, int n2) {
        return new Point((int)Math.floor((double)n / (double)this.mPieceUnit), (int)Math.floor((double)n2 / (double)this.mPieceUnit));
    }

    public Rectangle getClipBounds() {
        return this.calcClip().getBounds();
    }

    private Shape calcClip() {
        Area area = new Area();
        Rectangle rectangle = new Rectangle();
        Point[] pointArray = this.mModel.lastModified();
        for (int i = 0; i < pointArray.length; ++i) {
            rectangle.setBounds(pointArray[i].x * this.mPieceUnit, pointArray[i].y * this.mPieceUnit, this.mPieceUnit, this.mPieceUnit);
            area.add(new Area(rectangle));
        }
        return area;
    }

    RendererLocator getLocator() {
        return this.mLocator;
    }
}

