/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.AbstractDefaultRendererFactory;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderEvent;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.Renderer;
import jp.gr.java_conf.ktz.puzzle.fillo.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.framework.util.GUIUtility;

public class FilloDefaultRendererFactory
extends AbstractDefaultRendererFactory {
    protected Renderer createDefaultRenderer() {
        return new DefaltRenderer();
    }

    private static final class DefaltRenderer
    implements Renderer {
        private BufferedImage mCachedImage;

        private DefaltRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render(RenderEvent renderEvent) {
            Graphics graphics = renderEvent.getGraphics();
            Rectangle rectangle = renderEvent.getBounds();
            if (null == this.mCachedImage) {
                Graphics graphics2 = null;
                try {
                    this.mCachedImage = GUIUtility.createImage((int)rectangle.width, (int)rectangle.height);
                    graphics2 = this.mCachedImage.createGraphics();
                    graphics2.setColor(AppColors.SPACE);
                    graphics2.fillRect(0, 0, rectangle.width, rectangle.height);
                    float f = (float)((double)(rectangle.width > rectangle.height ? rectangle.width : rectangle.height) * 0.05);
                    graphics2.setColor(AppColors.WALL_COLOR);
                    ((Graphics2D)graphics2).setStroke(new BasicStroke(f));
                    Line2D.Float float_ = new Line2D.Float();
                    ((Line2D)float_).setLine(0.0, 0.0, (double)rectangle.width * 0.1, 0.0);
                    this.drawLine((Graphics2D)graphics2, float_, 0, 0);
                    this.drawLine((Graphics2D)graphics2, float_, (int)((double)rectangle.width * 0.9), 0);
                    this.drawLine((Graphics2D)graphics2, float_, 0, rectangle.height);
                    this.drawLine((Graphics2D)graphics2, float_, (int)((double)rectangle.width * 0.9), rectangle.height);
                    ((Line2D)float_).setLine(0.0, 0.0, 0.0, (int)((double)rectangle.height * 0.1));
                    this.drawLine((Graphics2D)graphics2, float_, 0, 0);
                    this.drawLine((Graphics2D)graphics2, float_, rectangle.width, 0);
                    this.drawLine((Graphics2D)graphics2, float_, 0, (int)((double)rectangle.height * 0.9));
                    this.drawLine((Graphics2D)graphics2, float_, rectangle.width, (int)((double)rectangle.height * 0.9));
                }
                finally {
                    graphics2.dispose();
                }
            }
            graphics.translate(rectangle.x, rectangle.y);
            graphics.drawImage(this.mCachedImage, 0, 0, null);
            graphics.translate(-rectangle.x, -rectangle.y);
        }

        private void drawLine(Graphics2D graphics2D, Line2D line2D, int n, int n2) {
            graphics2D.translate(n, n2);
            graphics2D.draw(line2D);
            graphics2D.translate(-n, -n2);
        }
    }
}

