/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.fillo.app.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.fillo.util.StateEventUtility;
import jp.gr.java_conf.ktz.puzzle.framework.DecoratedStateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.NumberState;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.SpaceState;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;

public class EditableNumberStateManagerImpl
extends DecoratedStateManagerImpl {
    public static final String SPACE_ID = "s";
    private Map mStateMap = new HashMap();
    private State mTransit;

    public EditableNumberStateManagerImpl() {
        this(null);
    }

    public EditableNumberStateManagerImpl(StateManagerImpl stateManagerImpl) {
        super(stateManagerImpl);
        this.initMap();
    }

    private void initMap() {
        StateEventCode stateEventCode = StateEventUtility.getNumberStateEventCode(SPACE_ID);
        this.mStateMap.put(stateEventCode, SpaceState.getInstance());
    }

    protected State createStateOfSelf(String string) {
        StateEventCode stateEventCode = StateEventUtility.getNumberStateEventCode(string);
        if (stateEventCode == null) {
            throw new IllegalArgumentException("The inStateID : '" + string + "' is illegal.");
        }
        if (this.mStateMap.containsKey(stateEventCode)) {
            return (State)this.mStateMap.get(stateEventCode);
        }
        return this.idsToState(string, stateEventCode);
    }

    private State idsToState(String string, StateEventCode stateEventCode) {
        NumberState numberState = null;
        try {
            int n = Integer.parseInt(string);
            numberState = new NumberState(n);
            this.mStateMap.put(stateEventCode, numberState);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The inStateID : " + string + " is illegal.");
        }
        return numberState;
    }

    protected State createDefaultStateSelf() {
        return this.createStateOfSelf(SPACE_ID);
    }

    protected String findIdentityOfSelf(State state) {
        Iterator iterator = this.mStateMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getValue().equals(state)) continue;
            return ((StateEventCode)entry.getKey()).getValue();
        }
        return SPACE_ID;
    }

    protected State getNextStateSelf(State state) {
        throw new UnsupportedOperationException("getNextStateSelf(State) method is not supported.");
    }

    protected State getNextStateSelf(State state, StateEventCode stateEventCode) {
        return this.getTransitedState(stateEventCode);
    }

    protected State getPrevStateSelf(State state) {
        throw new UnsupportedOperationException("getPrevStateSelf(State) method is not supported.");
    }

    protected State getPrevStateSelf(State state, StateEventCode stateEventCode) {
        return this.getTransitedState(stateEventCode);
    }

    private State getTransitedState(StateEventCode stateEventCode) {
        State state = (State)this.mStateMap.get(stateEventCode);
        if (state != null) {
            return state;
        }
        return this.idsToState(stateEventCode.getValue(), stateEventCode);
    }

    protected boolean isNumberStateSelf(State state) {
        return state instanceof NumberState;
    }

    protected boolean isSpaceStateSelf(State state) {
        return state instanceof SpaceState;
    }

    protected boolean isTransitSelf(State state) {
        throw new UnsupportedOperationException("isTransitSelf(State) method is not supported.");
    }

    protected boolean isTransitSelf(State state, StateEventCode stateEventCode) {
        return this.mStateMap.get(stateEventCode) != state;
    }

    protected boolean acceptableEventCode(StateEventCode stateEventCode) {
        return StateEventUtility.isNumberStateEventCode(stateEventCode);
    }
}

