/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.fillo.app.controller;

import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.ChangeEventFactory;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.ChangeHandler;
import jp.gr.java_conf.ktz.puzzle.fillo.util.InputUtility;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.DecoratedState;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;

public class FilloChangeHandler
implements ChangeHandler {
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private Point mActivePos;
    private Model mModel;

    public FilloChangeHandler(Model model) {
        this.mModel = model;
        this.mActivePos = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public boolean notifySelectionChanged(int n, int n2, boolean bl, boolean bl2) {
        Point point = new Point(n, n2);
        if (point.equals(this.mActivePos)) {
            return false;
        }
        this.mActivePos = point;
        StateEventCode stateEventCode = ChangeEventFactory.createSelectionEvent(true);
        this.mModel.nextStateAt(n, n2, stateEventCode);
        return this.mModel.isModified();
    }

    boolean isActivePos(Point point) {
        return this.mActivePos.equals(point);
    }

    public boolean notifyInputOccured(String string) {
        if (this.isSameInput(this.mActivePos, string)) {
            return false;
        }
        if (!this.velifyInputRange(string)) {
            return false;
        }
        StateEventCode stateEventCode = ChangeEventFactory.createNumberInputEvent(string);
        this.mModel.nextStateAt(this.mActivePos.x, this.mActivePos.y, stateEventCode);
        return this.mModel.isModified();
    }

    boolean velifyInputRange(String string) {
        if (InputUtility.isDeleteOccured(string)) {
            return true;
        }
        int n = InputUtility.getInputValue(string);
        return this.velifyInputRangeSub(string, n, new Point(this.mActivePos), new HashSet());
    }

    private boolean velifyInputRangeSub(String string, int n, Point point, Set set) {
        set.add(new Point(point));
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            Point point2 = DIRECTIONS[i].getDifference();
            point.translate(point2.x, point2.y);
            if (this.mModel.isNumberAt(point.x, point.y) && !set.contains(point) && this.isSameInput(point, string)) {
                if (n <= set.size()) {
                    return false;
                }
                if (!this.velifyInputRangeSub(string, n, point, set)) {
                    return false;
                }
            }
            point.translate(-point2.x, -point2.y);
        }
        if (n < set.size()) {
            throw new RuntimeException();
        }
        return n >= set.size();
    }

    State peelState(State state) {
        if (state instanceof DecoratedState) {
            return this.peelState(((DecoratedState)state).getDecorated());
        }
        return state;
    }

    boolean isSameInput(Point point, String string) {
        if (null == string) {
            throw new IllegalArgumentException("inVal is null");
        }
        State state = this.peelState(this.mModel.getCurStateAt(point.x, point.y));
        String string2 = StateManager.getInstance().findIdentityOf(state);
        return string2.equals(string);
    }
}

