/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ffplug.rcp.views.dialog;

import jp.sourceforge.ffplug.rcp.models.data.Constants;
import jp.sourceforge.ffplug.rcp.models.data.Resources;
import jp.sourceforge.ffplug.rcp.models.table.SynthPredicate;
import org.apache.log4j.Logger;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SearchDialogComposite
extends Composite {
    static Logger log;
    private Group groupKind = null;
    private Group groupCap = null;
    private Text textCapBase = null;
    private Combo comboCapRange = null;
    private Combo comboKind = null;
    private Button checkBoxSubskill = null;
    private Group groupText = null;
    private Text text = null;
    private Group groupTarget = null;
    private Group groupRep = null;
    private Button checkBoxHq = null;
    private Button checkBoxIngredient = null;
    private Button checkBoxText = null;
    private Button checkBoxBasic = null;
    private Button checkBoxDiv = null;
    private Button checkBoxItem = null;
    private Button checkBoxUnknwon = null;
    private Combo comboRank = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.ffplug.rcp.views.dialog.SearchDialogComposite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((String)clazz.getName());
    }

    private void createGroupSkill() {
        GridData gridData2 = new GridData();
        this.groupKind = new Group((Composite)this, 0);
        this.createComboKind();
        this.checkBoxSubskill = new Button((Composite)this.groupKind, 32);
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 2;
        gridData2.grabExcessHorizontalSpace = true;
        this.groupKind.setLayoutData((Object)gridData2);
        this.groupKind.setText("kind");
        this.groupKind.setLayout(null);
        this.checkBoxSubskill.setBounds(new Rectangle(100, 12, 71, 20));
        this.checkBoxSubskill.setText("subskill");
        this.checkBoxSubskill.setToolTipText("sub skill");
    }

    private void createGroupCap() {
        GridData gridData1 = new GridData();
        this.groupCap = new Group((Composite)this, 0);
        this.checkBoxUnknwon = new Button((Composite)this.groupCap, 32);
        this.textCapBase = new Text((Composite)this.groupCap, 2048);
        this.createComboCapRange();
        this.createCombo();
        gridData1.horizontalAlignment = 4;
        gridData1.verticalAlignment = 2;
        gridData1.grabExcessHorizontalSpace = false;
        this.groupCap.setLayoutData((Object)gridData1);
        this.groupCap.setText("cap");
        this.groupCap.setLayout(null);
        this.textCapBase.setBounds(new Rectangle(5, 46, 60, 20));
        gridData1.grabExcessVerticalSpace = false;
        this.checkBoxUnknwon.setBounds(new Rectangle(105, 24, 67, 16));
        this.checkBoxUnknwon.setText("unknown");
        this.checkBoxUnknwon.setToolTipText("unknown skillcap");
    }

    private void createComboCapRange() {
        this.comboCapRange = new Combo((Composite)this.groupCap, 8);
        this.comboCapRange.setBounds(new Rectangle(91, 46, 60, 20));
        int i = 0;
        while (i < 60) {
            this.comboCapRange.add("+" + i);
            ++i;
        }
        this.comboCapRange.select(30);
    }

    private void createComboKind() {
        this.comboKind = new Combo((Composite)this.groupKind, 8);
        this.comboKind.setBounds(new Rectangle(2, 12, 88, 20));
        this.comboKind.add(" - ");
        this.comboKind.add(Resources.getString("ffplug.skill.0"));
        this.comboKind.add(Resources.getString("ffplug.skill.1"));
        this.comboKind.add(Resources.getString("ffplug.skill.2"));
        this.comboKind.add(Resources.getString("ffplug.skill.3"));
        this.comboKind.add(Resources.getString("ffplug.skill.4"));
        this.comboKind.add(Resources.getString("ffplug.skill.5"));
        this.comboKind.add(Resources.getString("ffplug.skill.6"));
        this.comboKind.add(Resources.getString("ffplug.skill.7"));
        this.comboKind.add(Resources.getString("ffplug.skill.8"));
        this.comboKind.select(0);
    }

    private void createGroupText() {
        GridData gridData4 = new GridData();
        this.groupText = new Group((Composite)this, 0);
        this.text = new Text((Composite)this.groupText, 2048);
        this.groupText.setLayout((Layout)new FillLayout());
        this.groupText.setText("text");
        this.groupText.setLayoutData((Object)gridData4);
        gridData4.horizontalAlignment = 4;
        gridData4.verticalAlignment = 2;
    }

    private void createGroupTarget() {
        GridData gridData11 = new GridData();
        this.groupTarget = new Group((Composite)this, 0);
        this.checkBoxHq = new Button((Composite)this.groupTarget, 32);
        this.checkBoxIngredient = new Button((Composite)this.groupTarget, 32);
        this.checkBoxText = new Button((Composite)this.groupTarget, 32);
        this.groupTarget.setLayout((Layout)new FillLayout());
        this.groupTarget.setText("target");
        this.groupTarget.setLayoutData((Object)gridData11);
        gridData11.horizontalAlignment = 4;
        gridData11.verticalAlignment = 2;
        this.checkBoxHq.setText("hq");
        this.checkBoxHq.setToolTipText("HQ");
        this.checkBoxIngredient.setText("ingred");
        this.checkBoxIngredient.setToolTipText("ingredient");
        this.checkBoxText.setText("text");
        this.checkBoxText.setToolTipText("text description");
    }

    private void createGroupRep() {
        GridData gridData21 = new GridData();
        this.groupRep = new Group((Composite)this, 0);
        this.checkBoxBasic = new Button((Composite)this.groupRep, 32);
        this.checkBoxDiv = new Button((Composite)this.groupRep, 32);
        this.checkBoxItem = new Button((Composite)this.groupRep, 32);
        this.groupRep.setText("rep");
        this.groupRep.setToolTipText("target rep");
        this.groupRep.setLayoutData((Object)gridData21);
        this.groupRep.setLayout((Layout)new FillLayout());
        gridData21.horizontalAlignment = 4;
        gridData21.verticalAlignment = 2;
        this.checkBoxBasic.setText("basic");
        this.checkBoxBasic.setToolTipText("basic recipe");
        this.checkBoxDiv.setText("div");
        this.checkBoxDiv.setToolTipText("division");
        this.checkBoxItem.setText("item");
        this.checkBoxItem.setToolTipText("item");
    }

    private void createCombo() {
        this.comboRank = new Combo((Composite)this.groupCap, 8);
        this.comboRank.setBounds(new Rectangle(5, 22, 85, 16));
        this.comboRank.add(" - ");
        int i = 0;
        while (i < 10) {
            this.comboRank.add(Constants.RANK_NAMES[i]);
            ++i;
        }
        this.comboRank.select(0);
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(new Point(300, 200));
        new SearchDialogComposite((Composite)shell, 0);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public SearchDialogComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        this.createGroupText();
        this.createGroupSkill();
        this.createGroupCap();
        this.createGroupTarget();
        this.createGroupRep();
        this.setLayout((Layout)new GridLayout());
        this.setToolTipText("");
        this.setSize(new Point(202, 252));
    }

    public void makeViewFromPredicate(SynthPredicate predicate) {
        int capRange;
        int capBase;
        int kind;
        String textStr = predicate.getText();
        if (textStr != null) {
            this.text.setText(predicate.getText());
        }
        if ((kind = predicate.getKind()) >= -1) {
            this.comboKind.select(kind + 1);
        }
        this.checkBoxSubskill.setSelection(predicate.isSubskill());
        int capRank = predicate.getCapRank();
        if (-1 <= capRank && capRank <= 9) {
            this.comboRank.select(capRank + 1);
        }
        if ((capBase = predicate.getCapBase()) > 0) {
            this.textCapBase.setText("" + capBase);
        }
        if ((capRange = predicate.getCapRange()) >= 0) {
            this.comboCapRange.select(capRange);
        }
        this.checkBoxUnknwon.setSelection(predicate.isCapIncludeUnknown());
        this.checkBoxBasic.setSelection(predicate.isRepBasic());
        this.checkBoxDiv.setSelection(predicate.isRepDiv());
        this.checkBoxItem.setSelection(predicate.isRepItem());
        this.checkBoxHq.setSelection(predicate.isTargetHq());
        this.checkBoxIngredient.setSelection(predicate.isTargetIngredient());
        this.checkBoxText.setSelection(predicate.isTargetText());
    }

    public SynthPredicate makePredicateFromView() {
        SynthPredicate predicate = new SynthPredicate();
        String textStr = this.text.getText();
        if (textStr != null && !textStr.equals("")) {
            predicate.setText(textStr);
        }
        int comboKindInt = this.comboKind.getSelectionIndex();
        predicate.setKind(comboKindInt - 1);
        boolean subskill = this.checkBoxSubskill.getSelection();
        predicate.setSubskill(subskill);
        int comboRankInt = this.comboRank.getSelectionIndex();
        predicate.setCapRank(comboRankInt - 1);
        String textCapBaseStr = this.textCapBase.getText();
        try {
            int textCapBaseInt = Integer.parseInt(textCapBaseStr);
            predicate.setCapBase(textCapBaseInt);
        }
        catch (NumberFormatException e) {
            log.debug((Object)e);
        }
        int comboCapRangeInt = this.comboCapRange.getSelectionIndex();
        predicate.setCapRange(comboCapRangeInt);
        predicate.setCapIncludeUnknown(this.checkBoxUnknwon.getSelection());
        predicate.setRepBasic(this.checkBoxBasic.getSelection());
        predicate.setRepDiv(this.checkBoxDiv.getSelection());
        predicate.setRepItem(this.checkBoxItem.getSelection());
        predicate.setTargetHq(this.checkBoxHq.getSelection());
        predicate.setTargetIngredient(this.checkBoxIngredient.getSelection());
        predicate.setTargetText(this.checkBoxText.getSelection());
        predicate.makePredicate();
        return predicate;
    }
}

