/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ffplug.rcp.views;

import java.net.URL;
import jp.sourceforge.ffplug.rcp.FPlugin;
import jp.sourceforge.ffplug.rcp.models.data.Constants;
import jp.sourceforge.ffplug.rcp.models.table.BeanViewerSorter;
import jp.sourceforge.ffplug.rcp.models.table.PredicateViewerFilter;
import jp.sourceforge.ffplug.rcp.models.table.SynthPredicate;
import jp.sourceforge.ffplug.rcp.views.dialog.SearchDialogComposite;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class SearchView
extends ViewPart {
    static Logger log;
    private SearchDialogComposite searchComposite;
    private Action searchAction;
    private LinkedMap synths;
    private LinkedMap items;
    private TableViewer viewer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.ffplug.rcp.views.SearchView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((String)clazz.getName());
    }

    private void loadSessionData() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(Constants.MYPROJECT);
        this.synths = (LinkedMap)project.getSessionProperty(new QualifiedName(null, Constants.SESSION_SYNTH));
        this.items = (LinkedMap)project.getSessionProperty(new QualifiedName(null, Constants.SESSION_ITEM));
        this.viewer = (TableViewer)project.getSessionProperty(new QualifiedName(null, Constants.SESSION_VIEWER));
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(512));
        this.searchComposite = new SearchDialogComposite(parent, 0);
        this.makeActions();
        this.contributeToActionBars();
        try {
            this.loadSessionData();
        }
        catch (CoreException e) {
            log.error((Object)e);
        }
        this.searchComposite.makeViewFromPredicate(new SynthPredicate());
    }

    public void setFocus() {
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.searchAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.searchAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.searchAction);
    }

    private void makeActions() {
        this.searchAction = new SearchAction();
        this.searchAction.setText("search");
        this.searchAction.setToolTipText("search tooltip");
        URL urlSearch = FPlugin.getInstance().find((IPath)new Path("icons/search.gif"));
        this.searchAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)urlSearch));
    }

    private void resizeColumn(Table table) {
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].pack();
            ++i;
        }
    }

    private final class SearchAction
    extends Action {
        private SynthPredicate predicate;

        SearchAction() {
        }

        public void run() {
            try {
                SearchView.this.loadSessionData();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            log.debug((Object)"search action");
            SearchView.this.viewer.setInput(null);
            int i = 0;
            while (i < SearchView.this.viewer.getFilters().length) {
                SearchView.this.viewer.removeFilter(SearchView.this.viewer.getFilters()[i]);
                ++i;
            }
            this.predicate = SearchView.this.searchComposite.makePredicateFromView();
            SearchView.this.viewer.addFilter((ViewerFilter)new PredicateViewerFilter(this.predicate));
            SearchView.this.viewer.setInput((Object)SearchView.this.synths.values());
            int kind = this.predicate.getKind();
            if (kind >= 0 && kind <= 8) {
                SearchView.this.viewer.setSorter((ViewerSorter)new BeanViewerSorter("skillCap" + kind));
            }
            SearchView.this.resizeColumn(SearchView.this.viewer.getTable());
            SearchView.this.viewer.refresh();
        }
    }
}

