/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ffplug.rcp.models.data;

import java.util.Iterator;
import jp.sourceforge.ffplug.rcp.models.data.Constants;
import jp.sourceforge.ffplug.rcp.models.data.ItemPriceBean;
import jp.sourceforge.ffplug.rcp.models.data.SynthNameBean;

public class SynthPriceBean
extends SynthNameBean {
    private int materialTotalPrice;
    private int materialTotalShopPrice;
    private int materialTotalStackPrice;
    private int marginPerTrial;
    private int marginPerSlot;

    public SynthPriceBean() {
    }

    public SynthPriceBean(int recipeId, int itemId, int amount, int materialItemId1, int materialItemId2, int materialItemId3, int materialItemId4, int materialItemId5, int materialItemId6, int materialItemId7, int materialItemId8) {
        super(recipeId, itemId, amount, materialItemId1, materialItemId2, materialItemId3, materialItemId4, materialItemId5, materialItemId6, materialItemId7, materialItemId8);
    }

    public void calc() {
        this.calcMaterialTotalPrice();
        this.calcMarginPerTrial();
    }

    public void calcMaterialTotalPrice() {
        int sum = 0;
        Iterator i = this.getMaterials().iterator();
        while (i.hasNext()) {
            ItemPriceBean item = (ItemPriceBean)i.next();
            if (!item.hasAnyValue()) {
                return;
            }
            sum += item.getMinPrice();
        }
        int crystalPrice = Constants.CRYSTAL_PRICES[this.getCrystalId()];
        this.materialTotalPrice = sum + crystalPrice;
    }

    public void calcMarginPerTrial() {
        int itemMaxPrice = this.getItemMaxPrice();
        if (itemMaxPrice <= 0 || this.materialTotalPrice <= 0) {
            this.marginPerTrial = 0;
            return;
        }
        this.marginPerTrial = this.getItemMaxPrice() - this.materialTotalPrice;
    }

    public int getItemMaxPrice() {
        this.getItemMaxPriceBase();
        double amount = this.getAmount();
        double resultAmount = this.calcResultAmount(amount);
        double resultMax = (double)this.getItem().getMaxPrice() * resultAmount;
        return (int)resultMax;
    }

    private double calcResultAmount(double amount) {
        double resultAmount = amount * 0.95;
        return resultAmount;
    }

    public int getItemMaxPriceBase() {
        ItemPriceBean item = this.getItem();
        int max = item.getMaxPrice();
        return max *= this.getAmount();
    }

    public int getMarginPerSlot() {
        return this.marginPerSlot;
    }

    public void setMarginPerSlot(int marginPerSlot) {
        this.marginPerSlot = marginPerSlot;
    }

    public int getMarginPerTrial() {
        return this.marginPerTrial;
    }

    public void setMarginPerTrial(int marginPerTrial) {
        this.marginPerTrial = marginPerTrial;
    }

    public int getMaterialTotalPrice() {
        return this.materialTotalPrice;
    }

    public void setMaterialTotalPrice(int materialTotalPrice) {
        this.materialTotalPrice = materialTotalPrice;
    }

    public int getMaterialTotalShopPrice() {
        return this.materialTotalShopPrice;
    }

    public void setMaterialTotalShopPrice(int materialTotalShopPrice) {
        this.materialTotalShopPrice = materialTotalShopPrice;
    }

    public int getMaterialTotalStackPrice() {
        return this.materialTotalStackPrice;
    }

    public void setMaterialTotalStackPrice(int materialTotalStackPrice) {
        this.materialTotalStackPrice = materialTotalStackPrice;
    }
}

