/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ffplug.rcp.views;

import jp.sourceforge.ffplug.rcp.models.data.ItemPriceBean;
import jp.sourceforge.ffplug.rcp.models.data.SynthPriceBean;
import jp.sourceforge.ffplug.rcp.models.table.BeanListTableProvider;
import jp.sourceforge.ffplug.rcp.models.table.BeanViewerSorter;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.LinkedMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ItemView
extends ViewPart
implements ISelectionListener {
    private TableViewer viewer;
    private LinkedMap itemHeader;
    private BeanViewerSorter itemSorter;
    private Action action1;
    private Action action2;
    private Action doubleClickAction;

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 68352);
        this.itemSorter = new BeanViewerSorter("itemId");
        this.viewer.setSorter((ViewerSorter)this.itemSorter);
        this.itemHeader = new LinkedMap();
        this.itemHeader.put((Object)"ID   ", (Object)"itemId");
        this.itemHeader.put((Object)"Name ", (Object)"itemName");
        this.itemHeader.put((Object)"Text", (Object)"itemText");
        BeanListTableProvider provider = new BeanListTableProvider(this.itemHeader);
        Table tableItem = this.viewer.getTable();
        MapIterator i = provider.getHeader().mapIterator();
        while (i.hasNext()) {
            String colName = (String)i.next();
            TableColumn col = new TableColumn(tableItem, 0);
            col.setText(colName);
            col.pack();
        }
        tableItem.setHeaderVisible(true);
        tableItem.setLinesVisible(true);
        tableItem.setBounds(new Rectangle(18, 16, 200, 170));
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        String[] columnProperties = new String[this.itemHeader.size()];
        int i2 = 0;
        while (i2 < this.itemHeader.size()) {
            columnProperties[i2] = (String)this.itemHeader.getValue(i2);
            ++i2;
        }
        this.viewer.setColumnProperties(columnProperties);
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
        this.initializeListener();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.resizeColumn(tableItem);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void initializeListener() {
        Table tableItem = this.viewer.getTable();
        int i = 0;
        while (i < tableItem.getColumnCount()) {
            tableItem.getColumn(i).addSelectionListener((SelectionListener)new ColumnSortAdapter(this.viewer, this.itemHeader, i));
            ++i;
        }
    }

    private void resizeColumn(Table table) {
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].pack();
            ++i;
        }
    }

    private LinkedMap createDummyItemMap() {
        ItemPriceBean m1 = new ItemPriceBean(1, "item1");
        ItemPriceBean m2 = new ItemPriceBean(2, "item2");
        ItemPriceBean m3 = new ItemPriceBean(3, "item3");
        m1.setItemText("item1 description.");
        m2.setItemText("item2 description.");
        m3.setItemText("item3 description. long text test.");
        LinkedMap lmap = new LinkedMap();
        lmap.put((Object)new Integer(m1.getItemId()), (Object)m1);
        lmap.put((Object)new Integer(m2.getItemId()), (Object)m2);
        lmap.put((Object)new Integer(m3.getItemId()), (Object)m3);
        return lmap;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ItemView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.action2);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                ItemView.this.showMessage("Action 1 executed");
            }
        };
        this.action1.setText("Action 1");
        this.action1.setToolTipText("Action 1 tooltip");
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.action2 = new Action(){

            public void run() {
                ItemView.this.showMessage("Action 2 executed");
            }
        };
        this.action2.setText("Action 2");
        this.action2.setToolTipText("Action 2 tooltip");
        this.action2.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = ItemView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ItemView.this.showMessage("Double-click detected on " + obj.toString());
            }
        };
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Synth Table", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object first;
        System.out.println("selection changed. (ITEMS)");
        if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof SynthPriceBean) {
            SynthPriceBean synth = (SynthPriceBean)first;
            System.out.println("it's SynthNameBean id = [" + ((SynthPriceBean)first).getItemId() + "]");
            this.viewer.setInput((Object)synth.getMaterials());
            this.resizeColumn(this.viewer.getTable());
            this.viewer.refresh();
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ColumnSortAdapter
    implements SelectionListener {
        private TableViewer viewer;
        private LinkedMap header;
        private int column;
        private String key;
        private boolean reverse;

        ColumnSortAdapter(TableViewer viewer, LinkedMap header, int column) {
            this.viewer = viewer;
            this.header = header;
            this.column = column;
            this.key = (String)header.getValue(column);
        }

        public void widgetSelected(SelectionEvent e) {
            this.viewer.setSorter((ViewerSorter)new BeanViewerSorter(this.key, this.reverse));
            this.reverse = !this.reverse;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

