/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.ViewIntroAdapterPart;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.intro.IntroMessages;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;

public class WorkbenchIntroManager
implements IIntroManager {
    private final Workbench workbench;
    private IIntroPart introPart;

    WorkbenchIntroManager(Workbench workbench) {
        this.workbench = workbench;
    }

    public boolean closeIntro(IIntroPart part) {
        if (this.introPart == null || !this.introPart.equals(part)) {
            return false;
        }
        ViewIntroAdapterPart introView = this.getViewIntroAdapterPart();
        if (introView != null) {
            IWorkbenchPage page = introView.getSite().getPage();
            IViewReference reference = page.findViewReference("org.eclipse.ui.internal.introview");
            page.hideView(introView);
            if (reference == null || reference.getPart(false) == null) {
                this.introPart = null;
                return true;
            }
            return false;
        }
        return true;
    }

    public IIntroPart showIntro(IWorkbenchWindow preferredWindow, boolean standby) {
        if (preferredWindow == null) {
            preferredWindow = this.workbench.getActiveWorkbenchWindow();
        }
        if (preferredWindow == null) {
            return null;
        }
        if (this.getViewIntroAdapterPart() == null) {
            this.createIntro((WorkbenchWindow)preferredWindow);
        } else {
            try {
                ViewIntroAdapterPart viewPart = this.getViewIntroAdapterPart();
                WorkbenchPage page = (WorkbenchPage)viewPart.getSite().getPage();
                WorkbenchWindow window = (WorkbenchWindow)page.getWorkbenchWindow();
                if (!window.equals(preferredWindow)) {
                    window.getShell().setActive();
                }
                page.showView("org.eclipse.ui.internal.introview");
            }
            catch (PartInitException e) {
                WorkbenchPlugin.log("Could not open intro", (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "Could not open intro", (Throwable)((Object)e)));
            }
        }
        this.setIntroStandby(this.introPart, standby);
        return this.introPart;
    }

    boolean isIntroInWindow(IWorkbenchWindow testWindow) {
        ViewIntroAdapterPart viewPart = this.getViewIntroAdapterPart();
        if (viewPart == null) {
            return false;
        }
        WorkbenchPage page = (WorkbenchPage)viewPart.getSite().getPage();
        WorkbenchWindow window = (WorkbenchWindow)page.getWorkbenchWindow();
        return window.equals(testWindow);
    }

    private void createIntro(WorkbenchWindow preferredWindow) {
        if (this.workbench.getIntroDescriptor() == null) {
            return;
        }
        WorkbenchPage workbenchPage = preferredWindow.getActiveWorkbenchPage();
        if (workbenchPage == null) {
            return;
        }
        try {
            workbenchPage.showView("org.eclipse.ui.internal.introview");
        }
        catch (PartInitException e) {
            WorkbenchPlugin.log(IntroMessages.getString("Intro.could_not_create_part"), (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, IntroMessages.getString("Intro.could_not_create_part"), (Throwable)((Object)e)));
        }
    }

    public void setIntroStandby(IIntroPart part, boolean standby) {
        if (this.introPart == null || !this.introPart.equals(part)) {
            return;
        }
        ViewIntroAdapterPart viewIntroAdapterPart = this.getViewIntroAdapterPart();
        if (viewIntroAdapterPart == null) {
            return;
        }
        PartPane pane = ((PartSite)viewIntroAdapterPart.getSite()).getPane();
        if (standby == !pane.isZoomed()) {
            viewIntroAdapterPart.setStandby(standby);
            return;
        }
        ((WorkbenchPage)viewIntroAdapterPart.getSite().getPage()).toggleZoom(pane.getPartReference());
    }

    public boolean isIntroStandby(IIntroPart part) {
        if (this.introPart == null || !this.introPart.equals(part)) {
            return false;
        }
        ViewIntroAdapterPart viewIntroAdapterPart = this.getViewIntroAdapterPart();
        if (viewIntroAdapterPart == null) {
            return false;
        }
        return !((PartSite)viewIntroAdapterPart.getSite()).getPane().isZoomed();
    }

    public IIntroPart getIntro() {
        return this.introPart;
    }

    ViewIntroAdapterPart getViewIntroAdapterPart() {
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchWindow window = windows[i];
            WorkbenchPage page = (WorkbenchPage)window.getActivePage();
            if (page != null) {
                IPerspectiveDescriptor[] perspDescs = page.getOpenedPerspectives();
                int j = 0;
                while (j < perspDescs.length) {
                    IViewPart part;
                    IPerspectiveDescriptor descriptor = perspDescs[j];
                    IViewReference reference = page.findPerspective(descriptor).findView("org.eclipse.ui.internal.introview");
                    if (reference != null && (part = reference.getView(false)) != null && part instanceof ViewIntroAdapterPart) {
                        return (ViewIntroAdapterPart)part;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    IIntroPart createNewIntroPart() throws CoreException {
        this.introPart = this.workbench.getIntroDescriptor() == null ? null : this.workbench.getIntroDescriptor().createIntro();
        return this.introPart;
    }

    public boolean hasIntro() {
        return this.workbench.getIntroDescriptor() != null;
    }
}

