/*
 * Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.jxpath.util;

/**
 * A type converter can be installed on TypeUtils to introduce
 * additional type conversions for JXPath. Most of
 * the time BasicTypeConverter should be used as the superclass.
 *
 * @see TypeUtils#setTypeConverter
 *
 * @author Dmitri Plotnikov
 * @version $Revision: 1.4 $ $Date: 2004/02/29 14:17:43 $
 */
public interface TypeConverter {

    /**
     * Returns true if it can convert the supplied
     * object to the specified class.
     */
    boolean canConvert(Object object, Class toType);

    /**
     * Converts the supplied object to the specified
     * type. Throws a runtime exception if the conversion is
     * not possible.
     */
    Object convert(Object object, Class toType);
}