/*
 * $Id: MessageView.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2005/04/24
 */
package feat2.testapp.test1;

import feat2.CommandContext;
import feat2.View;
import feat2.config.ViewConfig;
import feat2.template.HTMLDocument;
import feat2.template.HTMLElement;

/**
 * 単一のメッセージを表示するビュー。
 * @author SUGIMOTO Ken-ichi
 */
public class MessageView implements View {

    private String message;
    private String title;
    private String elementId;

    public HTMLDocument format(HTMLDocument template, ViewConfig cfg, CommandContext ctx) throws Exception {

        // タイトルとメッセージを変更する

        ((HTMLElement)template.find("/html/head/title")).setText(title);
        template.findElement(elementId).setText(message);

        return template;

    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setElementId(String path) {
        this.elementId = path;
    }




}
