/*
 * $Id: IdentifierArrayConverter.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/03/22
 */
package feat2.config.type;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

import feat2.StringUtil;

/**
 * 識別子の配列へのコンバータ。
 * @author SUGIMOTO Ken-ichi
 */
public class IdentifierArrayConverter implements Converter {

    public Object convert(Class type, Object value) {

        if ( value == null )
            throw new ConversionException("null");

        try {

            Object[] inputValues = null;
            Identifier[] ret = null;

            // 入力値が配列の場合

            if ( value.getClass().isArray() ) {

                inputValues = (Object[])value;

            }

            // 入力値が配列以外の場合

            else {

                inputValues = StringUtil.split(value.toString());
                if ( inputValues == null )
                    throw new ConversionException("blank");

            }

            ret = new Identifier[inputValues.length];

            for (int i = 0; i < inputValues.length; i++) {
                ret[i] = new Identifier(inputValues[i].toString());
            }

            return ret;

        }

        catch (IllegalArgumentException ex) {
            throw new ConversionException(ex);
        }

    }

    /*public static void main(String[] args) {
        IdentifierArrayConverter conv = new IdentifierArrayConverter();
        Class c = (new Identifier[0]).getClass();
        Identifier[] test1 = (Identifier[])conv.convert(c, new String[] {"abc", "def", "ghi"});
        Identifier[] test2 = (Identifier[])conv.convert(c, new String[] {"abc", "123", "ghi"});
        Identifier[] test3 = (Identifier[])conv.convert(c, "  abc def　ghi  "); // 全角スペースで区切ると・・・
        boolean eq = Arrays.equals(test1, test3);
    }*/

}
