/*
 * $Id: FileDownload.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2004-2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/05/15
 */
package feat2;

import java.io.InputStream;

/**
 * ファイルダウンロードのレスポンス。
 * @author SUGIMOTO Ken-ichi
 */
public interface FileDownload {

    /**
     * ダウンロードファイルの内容の入力ストリームを返す。
     * @return 入力ストリームのインスタンス。nullを返してはいけない
     * @throws Exception
     */
    public InputStream getInputStream(CommandContext ctx) throws Exception;

    /**
     * ダウンロードファイルのファイル名を返す。
     * @return 設定ファイルで指定したファイル名を上書きしないときはnullを返す
     */
    public String getFileName();

    /**
     * ダウンロードファイルのMIMEタイプを返す。
     * @return 設定ファイルで指定したファイル名を上書きしないときはnullを返す
     */
    public String getMimeType();

}
