/*
 * $Id: TimeKeeper.java,v 1.1 2006/04/24 02:20:25 sugimotokenichi Exp $
 * Copyright (C) 2004-2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/04/23
 */
package feat2.testapp.test8;

import feat2.CommandContext;
import feat2.Interceptor;
import feat2.impl.Command;

public class TimeKeeper implements Interceptor {

    private long start;

    public void before(Command command, CommandContext ctx) {
        start = System.currentTimeMillis();
    }

    public void after(Command command, CommandContext ctx) {
        long elapse = System.currentTimeMillis() - start;
        ctx.getRequest().setAttribute("elapse", new Long(elapse));
    }

}
