/*
 * $Id: Test2View.java,v 1.1 2006/04/11 16:17:48 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/29
 */
package feat2.testapp.test2;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

import feat2.CommandContext;
import feat2.View;
import feat2.config.ViewConfig;
import feat2.template.HTMLDocument;

public class Test2View implements View {

    private Date date;
    private String random;
    private String count;

    public HTMLDocument format(HTMLDocument template, ViewConfig cfg,
            CommandContext ctx) throws Exception {

        Locale[] locale = ctx.getLocale();
        DateFormat fmt = DateFormat.getDateInstance(DateFormat.FULL, locale[0]);

        template.findElement("date").addText( fmt.format(date) );
        template.findElement("random").addText(random);
        template.findElement("count").addText(count);

        return template;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public void setRandom(String random) {
        this.random = random;
    }

    public void setDate(Date date) {
        this.date = date;
    }

}
