/*
 * $Id: SimpleDateValidator.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/09
 */
package feat2.validation;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;

import feat2.config.ConfigurationException;

/**
 * SimpleDateFormat̃p^[ɏ]ēť؂B
 * ͕̓lw肳ꂽp^[ŉ߂B
 * SimpleDateFormatlenient[hŌ؂B
 * @author SUGIMOTO Ken-ichi
 */
public class SimpleDateValidator implements SingleValueValidator {

    private SimpleDateFormat format;


    public boolean validate(String value) {

        if ( format == null )
            throw new ConfigurationException("exception.validator.simpledate.format");

        if ( ValidatorUtil.isBlankOrNull(value) )
            return true;

        try {
            format.parse(value);
        }
        catch (ParseException ex) {
            return false;
        }

        return true;
    }


    public void setPattern(String pattern) {
        format = new SimpleDateFormat(pattern);
        format.setLenient(true);
    }

    public String getDefaultMessageId() {
        return "error.validation.simpledate";
    }

    public Map getKeyrowds() {
        return null;
    }

}
