/*
 * $Id: IdentifierValidator.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/10
 */
package feat2.validation;

import java.util.Map;

import feat2.StringUtil;
import feat2.config.type.Identifier;

/**
 * featʎq܂͂̃Xg(󔒋؂)؂B
 * @author SUGIMOTO Ken-ichi
 */
public class IdentifierValidator implements SingleValueValidator {


    public boolean validate(String value) {

        if ( ValidatorUtil.isBlankOrNull(value) )
            return true;

        String[] list = StringUtil.split(value);

        for (int i = 0; i < list.length; i++) {
            if ( !Identifier.isIdentifier(list[i]) )
                return false;
        }

        return false;
    }

    public String getDefaultMessageId() {
        return "error.validation.identifier";
    }

    public Map getKeyrowds() {
        return null;
    }


}
