/*
 * $Id: FileTypeValidator.java,v 1.1 2006/04/18 16:12:53 sugimotokenichi Exp $
 * Copyright (C) 2004-2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/04/18
 */
package feat2.validation;

import java.util.HashMap;
import java.util.Map;

import feat2.CommandContext;
import feat2.StringUtil;

/**
 * Abv[hꂽt@C^Cv̌؁B
 * @author SUGIMOTO Ken-ichi
 */
public class FileTypeValidator implements ObjectValidator {

    private String[] acceptTypes;

    public boolean validate(Object value) {

        if ( value == null )
            return true;

        if ( acceptTypes == null || acceptTypes.length == 0 )
            return false;

        if ( value instanceof CommandContext.MultipartFormItem ) {
            CommandContext.MultipartFormItem item = (CommandContext.MultipartFormItem)value;
            String fileName = item.getFileName().toUpperCase();

            for (int i = 0; i < acceptTypes.length; i++) {
                String ext = "."+acceptTypes[i];
                if ( fileName.endsWith(ext) )
                    return true;
            }
        }

        return false;

    }

    public String getDefaultMessageId() {
        if ( acceptTypes.length == 1 )
            return "error.validation.filetype";
        else
            return "error.validation.filetypes";
    }

    public Map getKeyrowds() {
        HashMap ret = new HashMap();
        ret.put("types", StringUtil.join(acceptTypes, ", "));
        return ret;
    }


    /**
     * 󗝂łt@C̊gqXgݒ肷B
     * @param types pXy[X؂̊gqXgB擪ɃsIh͕tȂBr͑啶/ʂɍsB
     */
    public void setAcceptTypes(String types) {
        acceptTypes = StringUtil.split(types.toUpperCase(), " ");
    }

}
