/*
 * $Id: HTMLNodeListImpl.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬F 2005/07/29
 */
package feat2.template.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import feat2.template.HTMLNode;
import feat2.template.HTMLNodeList;


/**
 * m[h̃XgB
 * featev[gAPIDOM API̗ŎgpłB
 * @author SUGIMOTO
 */
public class HTMLNodeListImpl implements NodeList, HTMLNodeList {

    private List list;

    public HTMLNodeListImpl() {
        list = new ArrayList();
    }

    public void add(HTMLNode node) {
        list.add(node);
    }

    public int size() {
        return list.size();
    }

    public HTMLNode get(int index) {
        return (HTMLNode)list.get(index);
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(list).iterator();
    }


    // NodeList̎

    public int getLength() {
        return size();
    }

    public Node item(int index) {
        return TemplateUtil.toDomNode(get(index));
    }
}
