/*
 * $Id: RadioButton.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/12/17
 */
package feat2.template.form;

import feat2.template.HTMLElement;

/**
 * tH[̃WI{^B
 * @author SUGIMOTO Ken-ichi
 */
public class RadioButton implements FormControl {

    private HTMLElement[] elements;

    RadioButton(HTMLElement[] elements) {
        this.elements = elements;
    }

    /**
     * O[vꂽWI{^̗vfԂB
     * @return
     */
    public HTMLElement[] getElements() {
        return elements;
    }

    public HTMLElement getSelectedElement() {
        for(int i=0; i<elements.length; i++) {
            if ( elements[i].hasAttribute("checked") ) {
                return elements[i];
            }
        }
        return null;
    }

    public void setValue(String value) {
        for(int i=0; i<elements.length; i++) {
            String v = elements[i].getAttribute("value");
            if ( v != null && value != null && v.equals(value) ) {
                elements[i].setAttribute("checked", null);
            }
            else {
                elements[i].removeAttribute("checked");
            }
        }
    }

    public void setValues(String[] values) {
        if ( values != null && values.length > 0 )
            setValue(values[0]);
    }

    public String getValue() {
        HTMLElement elem = getSelectedElement();
        if ( elem != null )
            return elem.getAttribute("value");
        else
            return null;
    }

    public String[] getValues() {
        String value = getValue();
        if ( value != null )
            return new String[] {value};
        else
            return new String[0];
    }

    public HTMLElement getElement() {
        if ( elements.length > 0 )
            return elements[0];
        else
            return null;
    }

    public int getType() {
        return TYPE_RADIO;
    }

}
