/*
 * $Id: Cache.java,v 1.1 2006/05/10 14:07:44 sugimotokenichi Exp $
 * Copyright (C) 2004-2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/04/30
 */
package feat2.impl;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;

/**
 * w̎ԂIuWFNgێLbVBput, get, clean\bh
 * CacheCX^XgœB
 * @author SUGIMOTO Ken-ichi
 */
public class Cache {

    private HashMap buf;
    private long cleanTime;

    public Cache() {
        buf = new HashMap();
        cleanTime = 0;
    }


    /**
     * IuWFNgۑB
     * @param name L[
     * @param obj ۑIuWFNg
     * @param ttl IuWFNgۊǂő厞ԁB
     * q[vsƂ͂̎Ԃ葁IuWFNgj邱Ƃ
     */
    synchronized public void put(String name, Object obj, long ttl) {

        CacheEntry entry = new CacheEntry(obj, ttl);
        buf.put(name, entry);

    }


    /**
     * ۊǂꂽIuWFNgԂB
     * @param name L[
     * @return IuWFNgۊǂĂ΂̎QƁBIuWFNgȂAjĂnull
     */
    synchronized public Object get(String name) {

        CacheEntry entry = (CacheEntry)buf.get(name);
        if ( entry != null ) {

            Object ret = entry.get();
            if ( ret == null )
                buf.remove(name);
            return ret;

        }

        return null;

    }


    /**
     * LbV̕svȃIuWFNgJBAK[xbWRNV͍sȂB
     * @param interval sԊuBǑĂяo炱̎Ԃo߂ĂȂΏsȂ
     * @param limit sԐB̎Ԃ𒴉߂Ƃ܂IĂȂĂ^[
     */
    synchronized void clean(long interval, long limit) {

        if ( cleanTime+interval < System.currentTimeMillis() ) {

            long start = cleanTime = System.currentTimeMillis();
            for(Iterator it = buf.keySet().iterator(); it.hasNext(); ) {

                String name = (String)it.next();
                CacheEntry entry = (CacheEntry)buf.get(name);

                if ( entry != null ) {

                    Object obj = entry.get();
                    if ( obj == null )
                        buf.remove(name);

                    if ( start+limit < System.currentTimeMillis() )
                        break;
                }
                else
                    buf.remove(name);

            }

        }

    }

    private class CacheEntry {

        private long time;
        private long ttl;
        private SoftReference ref;

        private CacheEntry(Object obj, long ttl) {
            ref = new SoftReference(obj);
            this.ttl = ttl;
            this.time = System.currentTimeMillis();
        }

        private Object get() {
            Object ret = ref.get();
            if ( ret != null && time+ttl < System.currentTimeMillis() ) {
                ret = null;
            }

            return ret;
        }

    }
}
