/*
 * $Id: PageConfig.java,v 1.2 2006/05/12 10:47:36 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/20
 */
package feat2.config;

import java.util.ArrayList;

import feat2.FeatErrors;
import feat2.Response;
import feat2.impl.PageResponse;

/**
 * y[WX|X̐ݒB
 * @author SUGIMOTO Ken-ichi
 */
public class PageConfig extends ResponseConfigBase {

    private String template;
    private ArrayList views;
    private Integer maxAge;

    // validate\bhŗLɂȂϐ ---------------------------------------

    private FileLocator templateFile;


    // RXgN^ ---------------------------------------------------------

    public PageConfig() {
        views = new ArrayList();
    }


    // vpeB -------------------------------------------------------------

    public FileLocator getTemplateFile() {
        return templateFile;
    }

    public void addView(ViewConfig view) {
        views.add(view);
        view.setParent(this);
    }
    public ViewConfig[] getViews() {
        return (ViewConfig[])views.toArray(new ViewConfig[0]);
    }

    public Response getResponseInstance() {
        return new PageResponse(this);
    }

    public String getTemplate() {
        return template;
    }
    public void setTemplate(String template) {
        this.template = template;
    }

    public Integer getMaxAge() {
        return maxAge;
    }
    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }


    // Config̃\bh -------------------------------------------------------

    public String getElementName() {
        return "page";
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = super.validate(errs);

        if ( ConfigUtil.validateRequired(template, "template", this, errs) ) {
            FileLocator templateDir = getFeatConfig().getAppRootLocator().newLocation(getFeatureConfig().getTemplatePath());
            templateFile = templateDir.newLocation(template);
        }
        else
            ret = false;

        // qvf̌

        ret = ret && ConfigUtil.validate(views.iterator(), errs);

        return ret;
    }


}
