/*
 * $Id: ExceptionConfig.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/21
 */
package feat2.config;

import feat2.FeatError;
import feat2.FeatErrors;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;

/**
 * OJڂ̐ݒB
 * @author SUGIMOTO Ken-ichi
 */
public class ExceptionConfig extends Config {

    private JavaIdentifier catchType;
    private Identifier responseName;

    // validation\bhŗLɂȂϐ -------------------------------------

    private ResponseConfigBase response;
    private Class catchClass;


    // vpeB -------------------------------------------------------------

    public JavaIdentifier getCatchType() {
        return catchType;
    }
    public void setCatchType(JavaIdentifier catchType) {
        this.catchType = catchType;
    }

    public Class getCatchClass() {
        return catchClass;
    }

    public Identifier getResponseName() {
        return responseName;
    }
    public void setResponseName(Identifier responseName) {
        this.responseName = responseName;
    }

    public ResponseConfigBase getResponse() {
        return response;
    }

    // Config̃\bh -------------------------------------------------------

    public String getElementName() {
        return "exception";
    }

    public Identifier getName() {
        return null;
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = true;

        catchClass = ConfigUtil.validateClassLoading(catchType, "catch", this, errs);
        if ( catchClass == null )
            ret = false;

        if ( ConfigUtil.validateRequired(responseName, "response", this, errs) ) {
            response = getFeatureConfig().getResponseConfig(responseName.getValue());
            if ( response == null ) {
                ret = false;
                errs.add( new ConfigError(responseName.getValue(),
                        "error.config.exception.response.notfound",
                        FeatError.ERROR, this) );

            }
        }
        else
            ret = false;

        return ret;
    }


}
