/*
 * $Id: ConfigUtil.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/06
 */
package feat2.config;

import java.util.Iterator;
import java.util.List;

import feat2.FeatError;
import feat2.FeatErrors;
import feat2.ObjectUtil;
import feat2.ResourceManager;
import feat2.config.type.JavaIdentifier;

/**
 * ݒ̃[eBeBNXB
 * @author SUGIMOTO Ken-ichi
 */
public class ConfigUtil {

    /**
     * ؂̐ݒˑ֌W̏Ƀ\[gB
     * @param validations
     * @return
     * @throws ConfigurationException of[V̈ˑ֌WɏzQƂƂ
     * @deprecated
     */
    /*public static List sortValidation(List validations) throws ConfigurationException {
        ArrayList ret = new ArrayList();
        Dependencies dep = new Dependencies();

        // ˑ֌W

        for(int i=0; i<validations.size(); i++) {

            ValidationConfig config = (ValidationConfig)validations.get(i);
            dep.addDependency(config, null);

            // ˑׂĈˑ֌Wɒǉ

            ValidationConfig[] depends = config.getDepends();
            for(int ii=0; ii<depends.length; ii++) {

                dep.addDependency(config, depends[ii]);

            }

        }

        // š

        while( dep.count() > 0 ) {

            Object o = dep.getIndependentObject();
            if ( o == null ) {

                // ׂẴIuWFNgǂɈˑĂ̂ŁAzQ
                throw new ConfigurationException("error.config.ValidationConfig.recurrence");

            }

            dep.removeDependencies(o);
            ret.add(o);
        }

        return ret;
    }*/


    /**
     * Ce[^ŌJԂ邷ׂĂ̐ݒIuWFNg̃of[VsB
     * @param configIterator
     * @return
     */
    public static boolean validate(Iterator configIterator, FeatErrors errs) {

        boolean ret = true;

        while (configIterator.hasNext()) {
            Config conf = (Config) configIterator.next();
            ret = (ret && conf.validate(errs));
        }

        return ret;

    }

    /**
     * ẑׂĂ̐ݒIuWFNg̃of[VsB
     * @param configArray
     * @return
     */
    public static boolean validate(Config[] configArray, FeatErrors errs) {

        boolean ret = true;

        for (int i = 0; i < configArray.length; i++) {
            ret = (ret && configArray[i].validate(errs));
        }

        return ret;

    }


    /**
     * NX[hł邩`FbNB
     * @return [hꂽNXB[hɂ܂̓CX^X̍쐬ɎsnullB
     */
    public static Class validateClassLoading(JavaIdentifier className, String attrName, Config config, FeatErrors errs) {

        FeatureConfig featureConf = config.getFeatureConfig();
        if ( featureConf == null )
            return null;

        Class ret = null;

        if ( className == null ) {
            errs.add(new ConfigError(null, attrName, ConfigError.TYPE_NULL, FeatError.ERROR, config));
        }

        else {

            try {

                ret = ObjectUtil.loadClass(className.getValue(), featureConf.getPackageName().getValue());

            }
            catch (ClassNotFoundException ex) {
                errs.add(new ConfigError(className.getValue(), attrName, ConfigError.TYPE_CLASS_NOT_FOUND_EXCEPTION, FeatError.ERROR, config));
                ret = null;
            }

        }

        return ret;

    }


    /**
     * NX݂āAȂ̃RXgN^ŃCX^X쐬ł邩`FbNB
     * @param className NXBSCtB[`[Ŏw肳ꂽpbP[W̑Ζ
     * @param config ̃NX`Ăݒvf
     * @param errs G[̏o͐
     * @return [hꂽNXB[hɂ܂̓CX^X̍쐬ɎsnullB
     */
    public static Class validateClass(JavaIdentifier className, String attrName, Config config, FeatErrors errs) {

        FeatureConfig featureConf = config.getFeatureConfig();
        if ( featureConf == null )
            return null;

        Class ret = validateClassLoading(className, attrName, config, errs);

        if ( ret == null ) {
            return null;
        }

        else {

            try {

                ret.newInstance();

            }
            catch (InstantiationException ex) {
                errs.add(new ConfigError(className.getValue(), attrName, ConfigError.TYPE_INSTANTIATION_EXCEPTION, FeatError.ERROR, config));
                ret = null;
            }
            catch (IllegalAccessException ex) {
                errs.add(new ConfigError(className.getValue(), attrName, ConfigError.TYPE_ILLEGAL_ACCESS_EXCEPTION, FeatError.ERROR, config));
                ret = null;
            }

        }

        return ret;

    }

    /**
     * K{ڂ̃`FbNB
     */
    public static boolean validateRequired(Object value, String attrName, Config config, FeatErrors errs) {

        if ( value == null ) {
            errs.add( new ConfigError(null, attrName, ConfigError.TYPE_NULL, FeatError.ERROR, config) );
            return false;
        }

        return true;

    }

    public static boolean validateResource(String resourceId, Config config, ResourceManager rm, FeatErrors errs) {

        if ( rm.getStringResource(resourceId) == null ) {

            errs.add( new ConfigError(resourceId, "", ConfigError.TYPE_RESOURCE, FeatError.ERROR, config) );
            return false;

        }

        return true;

    }

    public static Config getConfig(List list, String name) {

        for (Iterator iter = list.iterator(); iter.hasNext();) {
            Config conf = (Config) iter.next();
            if ( name.equals(conf.getName().getValue()) ) {
                return conf;
            }
        }

        return null;
    }

}
