<?php
/**
@version $Id$
*/

class AdminThreadFilter extends AdminMessageFilter {
	var $sort_=array ("id","update_date","bbs_id","uid","name","title","parent");

	function getCriteria($start=0,$limit=0,$sort=0)
	{
		$criteria = parent::getCriteria($start,$limit,$sort);
		$criteria->add(new Criteria('parent',0));

		return $criteria;
	}

	function getDefaultCriteria($start,$limit)
	{
		$criteria=parent::getDefaultCriteria($start,$limit);
		$criteria->setSort('update_date');
		$criteria->setOrder('DESC');

		return $criteria;
	}
}

class AdminThreadTableModel extends AdminMessageTableModel {
	var $_column_=array("CHK", "ID","UPDATE_DATE","BBS_ID","UID","NAME","TITLE");

	function AdminThreadTableModel($component=null)
	{
		if(!$this->filter_)
			$this->filter_=new AdminThreadFilter();

		parent::AdminMessageTableModel($component);
	}

	function getValueAtUpdate_date($arr)
	{
		return formatTimestamp($arr['update_date']);
	}
}

?>