<?php
/**
@version $Id: user.php,v 1.8 2004/08/04 16:35:58 minahito Exp $
*/

require_once "xoops/user.php";
require_once "xoops/perm.php";

class YYBBSUser extends exXoopsUserObject {
	var $cookieUser_;
	
	function getStructure($type='s')
	{
		$ret=&parent::getStructure($type);
		if(is_object($this->cookieUser_))
			$ret['cookie']=$this->cookieUser_->getArray($type);

		return $ret;
	}

	function getStructure4User($type='s',$bbs_id=0)
	{
		global $xoopsModule;
		global $xoopsModuleConfig;

		$ret=$this->getStructure($type);

		// ѡߥå
		if($xoopsModuleConfig['permission'] and is_object($xoopsModule))
			$ret['perms']=exPerm::getPermNames_global($bbs_id);
		else
			$ret['perms']==0;
		
		return $ret;
	}


}

class YYBBSCookieUser extends exXoopsObject {
	function YYBBSCookieUser($name=null,$email=null,$url=null,$passwd=null,$icon=null,$col=null) {
		$this->initVar('name', XOBJ_DTYPE_TXTBOX, null, false, 60);
		$this->initVar('email', XOBJ_DTYPE_TXTBOX, null, true, 60);
		$this->initVar('url', XOBJ_DTYPE_TXTBOX, 'http://', false, 100);
		$this->initVar('passwd', XOBJ_DTYPE_TXTBOX, null, false, 32);
		$this->initVar('icon', XOBJ_DTYPE_TXTBOX, 1, false, 32);
		$this->initVar('col', XOBJ_DTYPE_TXTBOX, null, false, 32);

		if(is_array($name))
			$this->assignVars($name);
	}
	
	/**
	@brief åؤΥå
	*/
	function setCookie($cookiename='xoops_yybbs') {
		setcookie ( $cookiename,
				implode ( "<>",
				array ( $this->getVar('name','e'),$this->getVar('email','e'),$this->getVar('icon','e'),
					$this->getVar('col','e'),$this->getVar('passwd','e'),$this->getVar('url','e'))),
					time()+60*60*24*30 );
	}

	/**
	@brief å鼫ʬۤ
	*/
	function getCookie($cookiename='xoops_yybbs') {
		if(isset($_COOKIE[$cookiename])) {
			$ts=&MyTextSanitizer::getInstance();
			$tmp=explode("<>",$_COOKIE[$cookiename]);

			$this->setVar('name',$ts->stripSlashesGPC($ts->stripSlashesGPC($tmp[0])));
			$this->setVar('email',$ts->stripSlashesGPC($ts->stripSlashesGPC($tmp[1])));
			$this->setVar('icon',$ts->stripSlashesGPC($ts->stripSlashesGPC($tmp[2])));
			$this->setVar('col',$ts->stripSlashesGPC($ts->stripSlashesGPC($tmp[3])));
			$this->setVar('passwd',$ts->stripSlashesGPC($ts->stripSlashesGPC($tmp[4])));
			$this->setVar('url',$ts->stripSlashesGPC($ts->stripSlashesGPC($tmp[5])));
		}
	}

	/**
	@brief ꥯȤ
	*/
	function fetch() {
		$this->setVar('name',$_POST['name']);
		$this->setVar('email',$_POST['email']);
		$this->setVar('url',$_POST['url']);
		$this->setVar('passwd',$_POST['passwd']);
		$this->setVar('icon',$_POST['icon']);
		$this->setVar('col',$_POST['col']);
	}
}


?>