<?php
/**
@brief ѥåե륿ȥ鷺Ĥե
@version $Id$
*/

require_once "exForm/Filter.php";
require_once "exComponent/table/ListTable.php";

class AdminMessageFilter extends exAbstractFilterForm {
	var $thread_=false;
	var $bbs_id_=null;
	var $sort_=array ("id","inputdate","bbs_id","uid","name","title","parent");

	function fetch()
	{
		$this->thread_=(bool)($this->_getRequest('thread'));
		$this->bbs_id_=$this->getPositiveIntger('bbs_id');
	}

	function getCriteria($start=0,$limit=0,$sort=0)
	{
		$criteria = $this->getSortCriteria($start,$limit,$sort);
		if($this->bbs_id_)
			$criteria->add(new Criteria("bbs_id",$this->bbs_id_));

		return $criteria;
	}

	function getDefaultCriteria($start,$limit)
	{
		$criteria=parent::getDefaultCriteria($start,$limit);
		$criteria->setSort('inputdate');
		$criteria->setOrder('DESC');

		return $criteria;
	}

	function getExtra()
	{
		$ret =array();
		if($this->bbs_id_)
			$ret['bbs_id']=$this->bbs_id_;
		$ret['thread']=($this->thread_) ? 1 : 0;
		return $ret;
	}
}

class AdminMessageTableModel extends exListTableModel {
	var $_column_=array("CHK","ID","INPUTDATE","BBS_ID","UID","NAME","TITLE");
	var $filter_;

	function AdminMessageTableModel($component=null)
	{
		parent::exListTableModel($component);
		if(!$this->filter_)
			$this->filter_=new AdminMessageFilter();
	}

	function init() {
		$handler = YYBBS::getHandler('message');

		$this->listController_=new ListController();
		$this->listController_->filter_=&$this->filter_;
		$this->listController_->fetch($handler->getCount($this->filter_->getCriteria()),20);

		$objs = $handler->getObjects($this->listController_->getCriteria());
		foreach ( $objs as $mes ) {
			$this->_row_data_[]=$mes->getStructure();
		}

		return COMPONENT_MODEL_INIT_SUCCESS;
	}

	function getValueAtChk($arr)
	{
		return "<input type='checkbox' name='id[]' value='".$arr['id']."'>";
	}

	function getValueAtInputdate($arr)
	{
		return formatTimestamp($arr['inputdate']);
	}
}

class AdminListTableRender extends exListTableRender {
	function _fetchHtmlHead ()
	{
		$ret="";
		$ret.=parent::_fetchHtmlHead();
		$ret.="<form action='message_delete.php?thread=0' method='POST'>";
		return $ret;
	}

	function _fetchHtmlFoot ()
	{
		$ret="";
		$ret=parent::_fetchHtmlFoot();
		$ret.="<input type='submit' value='Delete'>";
		$ret.="</form>";
		return $ret;
	}
}

?>