<?php
/**
@file
@brief ǼĤα
@version $Id: MessageFilter.php,v 1.4 2004/07/25 16:23:07 minahito Exp $
*/

require_once "exForm/Filter.php";

class MessagePostFilter extends exAbstractFilterForm {

	function getCriteria($start=0,$limit=0)
	{
		$criteria = new CriteriaCompo();

		$criteria->setSort('inputdate');
		$criteria->setOrder('DESC');
		$criteria->setStart($start);
		$criteria->setLimit($limit);

		return ($criteria);
	}

	function getTotal()
	{
		$handler=&YYBBS::getHandler('message');
		return $handler->getCount($this->getCriteria());
	}
}

class MessageThreadFilter extends MessagePostFilter {
	var $bbs_id_=null;
	
	function fetch()
	{
		$this->bbs_id_=$this->getPositiveIntger('bbs_id');
	}

	function getCriteria($start=0,$limit=0)
	{
		$criteria = parent::getCriteria($start,$limit);

		if($this->bbs_id_)
			$criteria->add(new Criteria('bbs_id',$this->bbs_id_));

		$criteria->add(new Criteria('parent',0));
		$criteria->setSort('update_date');

		return $criteria;
	}

	function getExtra()
	{
		return array("bbs_id"=>$this->bbs_id_);
	}
}

?>
