/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.Modules;
import org.eclipse.jetty.start.Props;

public class ModuleGraphWriter {
    private String colorModuleBg = "#B8FFB8";
    private String colorEnabledBg = "#66FFCC";
    private String colorTransitiveBg = "#66CC66";
    private String colorCellBg = "#FFFFFF80";
    private String colorHeaderBg = "#00000020";
    private String colorModuleFont = "#888888";

    public void config(Props props) {
        String prefix = "jetty.graph.";
        this.colorModuleBg = this.getProperty(props, prefix + "color.module.bg", this.colorModuleBg);
        this.colorEnabledBg = this.getProperty(props, prefix + "color.enabled.bg", this.colorEnabledBg);
        this.colorTransitiveBg = this.getProperty(props, prefix + "color.transitive.bg", this.colorTransitiveBg);
        this.colorCellBg = this.getProperty(props, prefix + "color.cell.bg", this.colorCellBg);
        this.colorHeaderBg = this.getProperty(props, prefix + "color.header.bg", this.colorHeaderBg);
        this.colorModuleFont = this.getProperty(props, prefix + "color.font", this.colorModuleFont);
    }

    private String getProperty(Props props, String key, String defVal) {
        String val = props.getString(key, defVal);
        if (val == null) {
            return defVal;
        }
        if ((val = val.trim()).length() <= 0) {
            return defVal;
        }
        return val;
    }

    public void write(Modules modules, Path outputFile) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
             PrintWriter out = new PrintWriter(writer);){
            this.writeHeaderMessage(out, outputFile);
            out.println();
            out.println("digraph modules {");
            out.println("  node [color=gray, style=filled, shape=rectangle];");
            out.println("  node [fontname=\"Verdana\", size=\"20,20\"];");
            out.println("  graph [");
            out.println("    concentrate=false,");
            out.println("    fontname=\"Verdana\",");
            out.println("    fontsize = 20,");
            out.println("    rankdir = LR,");
            out.println("    ranksep = 1.5,");
            out.println("    nodesep = .5,");
            out.println("    style = bold,");
            out.println("    labeljust = l,");
            out.println("    label = \"Jetty Modules\",");
            out.println("    ssize = \"20,40\"");
            out.println("  ];");
            List<Module> enabled = modules.getEnabled();
            this.writeModules(out, modules, enabled);
            this.writeRelationships(out, modules, enabled);
            out.println("}");
            out.println();
        }
    }

    private void writeHeaderMessage(PrintWriter out, Path outputFile) {
        out.println("/*");
        out.println(" * GraphViz Graph of Jetty Modules");
        out.println(" * ");
        out.println(" * Jetty: http://eclipse.org/jetty/");
        out.println(" * GraphViz: http://graphviz.org/");
        out.println(" * ");
        out.println(" * To Generate Graph image using graphviz:");
        String filename = outputFile.getFileName().toString();
        String basename = filename.substring(0, filename.indexOf(46));
        out.printf(" *   $ dot -Tpng -Goverlap=false -o %s.png %s%n", basename, filename);
        out.println(" */");
    }

    private void writeModuleDetailHeader(PrintWriter out, String header) {
        this.writeModuleDetailHeader(out, header, 1);
    }

    private void writeModuleDetailHeader(PrintWriter out, String header, int count) {
        out.printf("  <TR>", new Object[0]);
        out.printf("<TD BGCOLOR=\"%s\" ALIGN=\"LEFT\"><I>", this.colorHeaderBg);
        out.printf("%s%s</I></TD>", header, count > 1 ? "s" : "");
        out.println("</TR>");
    }

    private void writeModuleDetailLine(PrintWriter out, String line) {
        out.printf("  <TR>", new Object[0]);
        StringBuilder escape = new StringBuilder();
        block4: for (char c : line.toCharArray()) {
            switch (c) {
                case '<': {
                    escape.append("&lt;");
                    continue block4;
                }
                case '>': {
                    escape.append("&gt;");
                    continue block4;
                }
                default: {
                    escape.append(c);
                }
            }
        }
        out.printf("<TD BGCOLOR=\"%s\" ALIGN=\"LEFT\">%s</TD></TR>%n", this.colorCellBg, escape.toString());
    }

    private void writeModuleNode(PrintWriter out, Module module, boolean resolved) {
        String color = this.colorModuleBg;
        if (module.isEnabled()) {
            color = this.colorEnabledBg;
        } else if (resolved) {
            color = this.colorTransitiveBg;
        }
        out.printf("  \"%s\" [ color=\"%s\" label=<", module.getName(), color);
        out.printf("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"2\">%n", new Object[0]);
        out.printf("  <TR><TD ALIGN=\"LEFT\"><B>%s</B></TD></TR>%n", module.getName());
        if (module.isEnabled()) {
            this.writeModuleDetailHeader(out, "ENABLED");
            for (String selection : module.getEnableSources()) {
                this.writeModuleDetailLine(out, "via: " + selection);
            }
        } else if (resolved) {
            this.writeModuleDetailHeader(out, "TRANSITIVE");
        }
        if (!module.getXmls().isEmpty()) {
            List<String> xmls = module.getXmls();
            this.writeModuleDetailHeader(out, "XML", xmls.size());
            for (String xml : xmls) {
                this.writeModuleDetailLine(out, xml);
            }
        }
        if (!module.getLibs().isEmpty()) {
            List<String> libs = module.getLibs();
            this.writeModuleDetailHeader(out, "LIB", libs.size());
            for (String lib : libs) {
                this.writeModuleDetailLine(out, lib);
            }
        }
        if (!module.getIniTemplate().isEmpty()) {
            List<String> inis = module.getIniTemplate();
            this.writeModuleDetailHeader(out, "INI Template", inis.size());
        }
        out.printf("</TABLE>>];%n", new Object[0]);
    }

    private void writeModules(PrintWriter out, Modules allmodules, List<Module> enabled) {
        out.println();
        out.println("  /* Modules */");
        out.println();
        out.println("  node [ labeljust = l ];");
        for (Module module : allmodules) {
            boolean resolved = enabled.contains(module);
            this.writeModuleNode(out, module, resolved);
        }
    }

    private void writeRelationships(PrintWriter out, Iterable<Module> modules, List<Module> enabled) {
        for (Module module : modules) {
            for (String depends : module.getDepends()) {
                depends = Module.normalizeModuleName(depends);
                out.printf("    \"%s\" -> \"%s\";%n", module.getName(), depends);
            }
            for (String optional : module.getOptional()) {
                out.printf("    \"%s\" => \"%s\";%n", module.getName(), optional);
            }
        }
    }
}

